/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.plugins.warnings.util.ChartBuilder;
import hudson.plugins.warnings.util.HealthAwarePublisher;
import hudson.plugins.warnings.util.PluginDescriptor;
import hudson.plugins.warnings.util.PrioritiesAreaRenderer;
import hudson.plugins.warnings.util.ResultAreaRenderer;
import hudson.plugins.warnings.util.ToolTipProvider;
import hudson.plugins.warnings.util.model.AnnotationProvider;
import hudson.plugins.warnings.util.model.Priority;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthReportBuilder
implements Serializable {
    private static final long serialVersionUID = 5191317904662711835L;
    private int healthy;
    private int unHealthy;
    private boolean isHealthEnabled;
    private String reportName;
    private String itemName;
    private boolean isThresholdEnabled;
    private int threshold;
    private final String reportSingleCount;
    private final String reportMultipleCount;

    public HealthReportBuilder(boolean isFailureThresholdEnabled, int threshold, boolean isHealthyReportEnabled, int healthy, int unHealthy, String reportSingleCount, String reportMultipleCount) {
        this.reportSingleCount = reportSingleCount;
        this.reportMultipleCount = reportMultipleCount;
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.isThresholdEnabled = isFailureThresholdEnabled;
        this.isHealthEnabled = isHealthyReportEnabled;
    }

    public HealthReportBuilder() {
        this(false, 0, false, 0, 0, "1 item", "%d items");
    }

    public HealthReport computeHealth(AnnotationProvider result, AbstractProject<?, ?> project, PluginDescriptor pluginDescriptor) {
        int numberOfAnnotations = result.getNumberOfAnnotations();
        DescribableList publishers = project.getPublishersList();
        Publisher publisher = (Publisher)publishers.get((Descriptor)pluginDescriptor);
        if (publisher instanceof HealthAwarePublisher) {
            HealthAwarePublisher healthAwarePublisher = (HealthAwarePublisher)publisher;
            numberOfAnnotations = 0;
            for (Priority priority : healthAwarePublisher.getPriorities()) {
                numberOfAnnotations += result.getNumberOfAnnotations(priority);
            }
        }
        return this.computeHealth(numberOfAnnotations, result);
    }

    public HealthReport computeHealth(int counter, AnnotationProvider result) {
        if (this.isHealthEnabled) {
            int percentage = counter < this.healthy ? 100 : (counter > this.unHealthy ? 0 : 100 - (counter - this.healthy) * 100 / (this.unHealthy - this.healthy));
            String description = this.isLocalizedRelease() ? this.createDescription(result) : this.reportName + ": " + Util.combine((long)result.getNumberOfAnnotations(), (String)this.itemName) + " found.";
            return new HealthReport(percentage, description);
        }
        return null;
    }

    private String createDescription(AnnotationProvider result) {
        String description = result.getNumberOfAnnotations() == 1 ? this.reportSingleCount : String.format(this.reportMultipleCount, result.getNumberOfAnnotations(), result.getNumberOfAnnotations(Priority.HIGH), Priority.HIGH.getLocalizedString(), result.getNumberOfAnnotations(Priority.NORMAL), Priority.NORMAL.getLocalizedString(), result.getNumberOfAnnotations(Priority.LOW), Priority.LOW.getLocalizedString());
        return description;
    }

    private boolean isLocalizedRelease() {
        return this.itemName == null;
    }

    public boolean isEnabled() {
        return this.isHealthEnabled || this.isThresholdEnabled;
    }

    public final int getHealthy() {
        return this.healthy;
    }

    public final void setHealthy(int healthy) {
        this.healthy = healthy;
    }

    public final int getUnHealthy() {
        return this.unHealthy;
    }

    public final void setUnHealthy(int unHealthy) {
        this.unHealthy = unHealthy;
    }

    public final boolean isHealthyReportEnabled() {
        return this.isHealthEnabled;
    }

    public final void setHealthyReportEnabled(boolean isHealthyReportEnabled) {
        this.isHealthEnabled = isHealthyReportEnabled;
    }

    public boolean isFailureThresholdEnabled() {
        return this.isThresholdEnabled;
    }

    public void setFailureThresholdEnabled(boolean isFailureThresholdEnabled) {
        this.isThresholdEnabled = isFailureThresholdEnabled;
    }

    public final String getReportName() {
        return this.reportName;
    }

    public final void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public final String getItemName() {
        return this.itemName;
    }

    public final void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public List<Integer> createSeries(int totalCount) {
        ArrayList<Integer> series = new ArrayList<Integer>(3);
        int remainder = totalCount;
        if (this.isHealthEnabled) {
            series.add(Math.min(remainder, this.healthy));
            int range = this.unHealthy - this.healthy;
            if ((remainder -= this.healthy) > 0) {
                series.add(Math.min(remainder, range));
            } else {
                series.add(0);
            }
            if ((remainder -= range) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else if (this.isThresholdEnabled) {
            series.add(Math.min(remainder, this.threshold));
            if ((remainder -= this.threshold) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        }
        return series;
    }

    public JFreeChart createGraph(boolean useHealthBuilder, String url, CategoryDataset dataset, ToolTipProvider toolTipProvider) {
        Object renderer = useHealthBuilder && this.isEnabled() ? new ResultAreaRenderer(url, toolTipProvider) : new PrioritiesAreaRenderer(url, toolTipProvider);
        return ChartBuilder.createChart((CategoryDataset)dataset, (StackedAreaRenderer)renderer, (int)this.getThreshold(), (this.isHealthyReportEnabled() || !this.isFailureThresholdEnabled() || !useHealthBuilder ? 1 : 0) != 0);
    }
}

