/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.parser.WarningsParser;
import hudson.plugins.warnings.util.JavaPackageDetector;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegexpParser
implements WarningsParser {
    protected static final String DEPRECATION = "Deprecation";
    protected static final String PROPRIETARY_API = "Proprietary API";
    private final Pattern pattern;

    public RegexpParser(String warningPattern) {
        this.pattern = Pattern.compile(warningPattern);
    }

    @Override
    public Collection<FileAnnotation> parse(InputStream file) throws IOException {
        LineIterator iterator = IOUtils.lineIterator((InputStream)file, null);
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        while (iterator.hasNext()) {
            String line = iterator.nextLine();
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.matches()) continue;
            Warning warning = this.createWarning(matcher);
            if (!warning.hasPackageName()) {
                String packageName = new JavaPackageDetector().detectPackageName(warning.getFileName());
                warning.setPackageName(packageName);
            }
            warnings.add(warning);
        }
        return warnings;
    }

    protected abstract Warning createWarning(Matcher var1);

    protected final int getLineNumber(String lineNumber) {
        try {
            return Integer.parseInt(lineNumber);
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    protected String classifyWarning(String message) {
        if (StringUtils.contains((String)message, (String)"proprietary")) {
            return PROPRIETARY_API;
        }
        if (StringUtils.contains((String)message, (String)"deprecated")) {
            return DEPRECATION;
        }
        return "";
    }
}

