/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.model.AbstractBuild;
import hudson.plugins.warnings.util.PrioritiesDetail;
import hudson.plugins.warnings.util.model.AnnotationContainer;
import hudson.plugins.warnings.util.model.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityDetailFactory {
    public boolean isPriority(String value) {
        for (Priority priority : Priority.values()) {
            if (!priority.toString().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public PrioritiesDetail create(String priority, AbstractBuild<?, ?> owner, AnnotationContainer container, String header) {
        if (Priority.HIGH.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.HIGH, owner, container, header);
        }
        if (Priority.NORMAL.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.NORMAL, owner, container, header);
        }
        if (Priority.LOW.toString().equalsIgnoreCase(priority)) {
            return this.createPrioritiesDetail(Priority.LOW, owner, container, header);
        }
        throw new IllegalArgumentException("Wrong priority provided: " + priority);
    }

    protected PrioritiesDetail createPrioritiesDetail(Priority priority, AbstractBuild<?, ?> owner, AnnotationContainer container, String header) {
        return new PrioritiesDetail(owner, container.getAnnotations(priority), priority, header);
    }
}

