/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsProjectAction;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.WarningsResultBuilder;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.util.HealthAwarePublisher;
import hudson.plugins.warnings.util.HealthReportBuilder;
import hudson.plugins.warnings.util.model.JavaProject;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsPublisher
extends HealthAwarePublisher {
    public static final WarningsDescriptor WARNINGS_DESCRIPTOR = new WarningsDescriptor();

    @DataBoundConstructor
    public WarningsPublisher(String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "WARNINGS");
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new WarningsProjectAction(project, this.getTrendHeight());
    }

    @Override
    public JavaProject perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Parsing warnings in log file...");
        File logFile = build.getLogFile();
        JavaProject project = new JavaProject();
        project.addAnnotations(new ParserRegistry().parse(logFile));
        WarningsResult result = new WarningsResultBuilder().build(build, project);
        HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.Warnings_ResultAction_HealthReportSingleItem(), Messages.Warnings_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new WarningsResultAction(build, healthReportBuilder, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return WARNINGS_DESCRIPTOR;
    }
}

