/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.ResultSummary;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.AnnotationsBuildResult;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsResult
extends AnnotationsBuildResult {
    private static final long serialVersionUID = -137460587767210579L;

    public WarningsResult(AbstractBuild<?, ?> build, ParserResult result) {
        super(build, result);
    }

    public WarningsResult(AbstractBuild<?, ?> build, ParserResult result, WarningsResult previous) {
        super(build, result, previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            return message + "<li>" + Messages.Warnings_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
        }
        return message;
    }

    @Override
    protected String getSerializationFileName() {
        return "compiler-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.Warnings_ProjectAction_Name();
    }

    @Override
    public JavaProject getPreviousResult() {
        WarningsResultAction action = (WarningsResultAction)this.getOwner().getAction(WarningsResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((WarningsResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    @Override
    public boolean hasPreviousResult() {
        return ((WarningsResultAction)this.getOwner().getAction(WarningsResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("warning", Warning.class);
    }
}

