/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.model.Priority;
import java.util.regex.Matcher;

public class GnatParser
extends RegexpParser {
    static final String WARNING_TYPE = "gnat";
    private static final String GNAT_WARNING_PATTERN = "^([^\\s]+):(\\d+):(\\d+): ((error:)|(warning:)|(\\(style\\))) (.+)$";

    public GnatParser() {
        super(GNAT_WARNING_PATTERN, true);
    }

    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        if ("warning:".equalsIgnoreCase(matcher.group(4))) {
            priority = Priority.NORMAL;
            category = "GNAT warning";
        } else if ("(style)".equalsIgnoreCase(matcher.group(4))) {
            priority = Priority.LOW;
            category = "GNAT style";
        } else {
            priority = Priority.HIGH;
            category = "GNAT error";
        }
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(8), priority);
    }
}

