/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.AntEclipseParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.ErlcParser;
import hudson.plugins.warnings.parser.GccParser;
import hudson.plugins.warnings.parser.GnatParser;
import hudson.plugins.warnings.parser.InvalidsParser;
import hudson.plugins.warnings.parser.JavaDocParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.SunCParser;
import hudson.plugins.warnings.parser.WarningsParser;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    private final List<WarningsParser> parsers = new ArrayList<WarningsParser>();
    private ExcludeFilter excludeFilter;

    public ParserRegistry() {
        this(null);
    }

    public ParserRegistry(String excludePattern) {
        this.parsers.add(new JavacParser());
        this.parsers.add(new AntJavacParser());
        this.parsers.add(new JavaDocParser());
        this.parsers.add(new AntEclipseParser());
        this.parsers.add(new MsBuildParser());
        this.parsers.add(new GccParser());
        this.parsers.add(new InvalidsParser());
        this.parsers.add(new SunCParser());
        this.parsers.add(new GnatParser());
        this.parsers.add(new ErlcParser());
        if (!StringUtils.isEmpty((String)excludePattern)) {
            this.excludeFilter = new ExcludeFilter(excludePattern);
        }
    }

    protected Iterable<WarningsParser> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    public Collection<FileAnnotation> parse(File file) throws IOException {
        ArrayList<FileAnnotation> allAnnotations = new ArrayList<FileAnnotation>();
        for (WarningsParser parser : this.parsers) {
            allAnnotations.addAll(parser.parse(this.createInputStream(file)));
        }
        if (this.excludeFilter == null) {
            return allAnnotations;
        }
        return this.filterAnnotations(allAnnotations);
    }

    private Collection<FileAnnotation> filterAnnotations(List<FileAnnotation> annotations) {
        ArrayList<FileAnnotation> filteredAnnotations = new ArrayList<FileAnnotation>();
        for (FileAnnotation annotation : annotations) {
            if (this.excludeFilter.matches(annotation.getFileName())) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    protected InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static final class ExcludeFilter
    extends DirectoryScanner {
        public ExcludeFilter(String excludePattern) {
            this.setExcludes(excludePattern.split(",\\s*"));
            this.setIncludes(new String[]{"**/*"});
        }

        public boolean matches(String name) {
            if (File.separatorChar == '\\') {
                return this.isExcluded(StringUtils.replaceChars((String)name, (char)'/', (char)'\\'));
            }
            return this.isExcluded(name);
        }
    }
}

