/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsProjectAction;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.WarningsResultBuilder;
import hudson.plugins.warnings.parser.FileWarningsParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.util.AnnotationParser;
import hudson.plugins.warnings.util.FilesParser;
import hudson.plugins.warnings.util.HealthAwarePublisher;
import hudson.plugins.warnings.util.HealthDescriptor;
import hudson.plugins.warnings.util.ParserResult;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsPublisher
extends HealthAwarePublisher {
    public static final WarningsDescriptor WARNINGS_DESCRIPTOR = new WarningsDescriptor();
    private final String pattern;
    private final String excludePattern;

    @DataBoundConstructor
    public WarningsPublisher(String threshold, String healthy, String unHealthy, String height, String thresholdLimit, String pattern, String excludePattern) {
        super(threshold, healthy, unHealthy, height, thresholdLimit, "WARNINGS");
        this.pattern = pattern;
        this.excludePattern = StringUtils.stripToNull((String)excludePattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new WarningsProjectAction(project, this.getTrendHeight());
    }

    public ParserResult perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        ParserResult project;
        this.log(logger, "Parsing warnings in log file...");
        File logFile = build.getLogFile();
        if (StringUtils.isNotBlank((String)this.getPattern())) {
            FilesParser parser = new FilesParser(logger, this.getPattern(), (AnnotationParser)new FileWarningsParser(this.getExcludePattern()), this.isMavenBuild(build), this.isAntBuild(build));
            project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
        } else {
            project = new ParserResult(build.getProject().getWorkspace());
        }
        project.addAnnotations(new ParserRegistry(this.getExcludePattern()).parse(logFile));
        WarningsResult result = new WarningsResultBuilder().build(build, project);
        build.getActions().add(new WarningsResultAction(build, (HealthDescriptor)this, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return WARNINGS_DESCRIPTOR;
    }
}

