/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.model.Priority;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class InvalidsParser
extends RegexpParser {
    static final String WARNING_TYPE = "Oracle ";
    private static final String INVALIDS_PATTERN = "\\s*(\\w+),([a-zA-Z#_0-9/]*),([A-Z_ ]*),(.*),(\\d+),\\d+,([^:]*):\\s*(.*)";

    public InvalidsParser() {
        super(INVALIDS_PATTERN);
    }

    protected Warning createWarning(Matcher matcher) {
        String type = WARNING_TYPE + StringUtils.capitalize((String)StringUtils.lowerCase((String)matcher.group(4)));
        String category = matcher.group(6);
        Priority priority = StringUtils.contains((String)category, (String)"PLW-07") ? Priority.LOW : (StringUtils.contains((String)category, (String)"ORA") ? Priority.HIGH : Priority.NORMAL);
        Warning warning = new Warning(matcher.group(2) + "." + matcher.group(3), this.getLineNumber(matcher.group(5)), type, category, matcher.group(7), priority);
        warning.setPackageName(matcher.group(1));
        return warning;
    }

    public String toString() {
        return WARNING_TYPE;
    }
}

