/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.warnings.util.AttributeDetail;
import hudson.plugins.warnings.util.ChartBuilder;
import hudson.plugins.warnings.util.ChartRenderer;
import hudson.plugins.warnings.util.Messages;
import hudson.plugins.warnings.util.ModuleDetail;
import hudson.plugins.warnings.util.PackageDetail;
import hudson.plugins.warnings.util.PriorityDetailFactory;
import hudson.plugins.warnings.util.SourceDetail;
import hudson.plugins.warnings.util.model.AnnotationContainer;
import hudson.plugins.warnings.util.model.AnnotationProvider;
import hudson.plugins.warnings.util.model.DefaultAnnotationContainer;
import hudson.plugins.warnings.util.model.FileAnnotation;
import hudson.plugins.warnings.util.model.JavaPackage;
import hudson.plugins.warnings.util.model.MavenModule;
import hudson.plugins.warnings.util.model.Priority;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationsDetail
extends AnnotationContainer
implements ModelObject {
    private static final long serialVersionUID = 1750266351592937774L;
    private final AbstractBuild<?, ?> owner;

    public AbstractAnnotationsDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String name, AnnotationContainer.Hierarchy hierarchy) {
        super(name, hierarchy);
        this.owner = owner;
        this.addAnnotations(annotations);
    }

    public String getHeader() {
        return this.getName() + " - " + this.getDisplayName();
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    protected final void createDetailGraph(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart((int)detailObject.getNumberOfAnnotations(Priority.HIGH), (int)detailObject.getNumberOfAnnotations(Priority.NORMAL), (int)detailObject.getNumberOfAnnotations(Priority.LOW), (int)upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString((String)priorityName).getLongLocalizedString();
    }

    public final Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, (AnnotationContainer)this, this.getDisplayName());
        }
        if (link.startsWith("module.")) {
            return new ModuleDetail(this.getOwner(), this.getModule(StringUtils.substringAfter((String)link, (String)"module.")), this.getDisplayName());
        }
        if (link.startsWith("package.")) {
            return new PackageDetail(this.getOwner(), this.getPackage(StringUtils.substringAfter((String)link, (String)"package.")), this.getDisplayName());
        }
        if (link.startsWith("source.")) {
            return new SourceDetail(this.getOwner(), this.getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")));
        }
        if (link.startsWith("category.")) {
            String category = StringUtils.substringAfter((String)link, (String)"category.");
            return new AttributeDetail(this.getOwner(), (Collection)this.getCategory(category), this.getDisplayName(), Messages.CategoryDetail_header() + " " + category);
        }
        if (link.startsWith("type.")) {
            String type = StringUtils.substringAfter((String)link, (String)"type.");
            return new AttributeDetail(this.getOwner(), (Collection)this.getType(type), this.getDisplayName(), Messages.TypeDetail_header() + " " + type);
        }
        return null;
    }

    public final void doStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("object");
        if (parameter.startsWith("category.")) {
            Set annotations = this.getCategory(StringUtils.substringAfter((String)parameter, (String)"category."));
            ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)new DefaultAnnotationContainer(annotations), (int)this.getAnnotationBound());
        } else if (parameter.startsWith("type.")) {
            Set annotations = this.getType(StringUtils.substringAfter((String)parameter, (String)"type."));
            ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)new DefaultAnnotationContainer(annotations), (int)this.getAnnotationBound());
        } else if (parameter.startsWith("package.")) {
            JavaPackage annotations = this.getPackage(StringUtils.substringAfter((String)parameter, (String)"package."));
            ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)annotations, (int)this.getAnnotationBound());
        } else if (parameter.startsWith("module.")) {
            MavenModule annotations = this.getModule(StringUtils.substringAfter((String)parameter, (String)"module."));
            ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)annotations, (int)this.getAnnotationBound());
        }
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }
}

