/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.plugins.warnings.util.FileInputStreamFactory;
import hudson.plugins.warnings.util.ModuleDetector;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public final class ModuleDetector {
    private static final String TARGET = "/target";
    private FileInputStreamFactory factory = new DefaultFileInputStreamFactory(null);

    public void setFileInputStreamFactory(FileInputStreamFactory fileInputStreamFactory) {
        this.factory = fileInputStreamFactory;
    }

    public String guessModuleName(String fileName) {
        String unixName = fileName.replace("\\", "/");
        String projectName = this.parsePom(unixName);
        if (StringUtils.isNotBlank((String)projectName)) {
            return projectName;
        }
        String path = StringUtils.substringBeforeLast((String)unixName, (String)"/");
        projectName = this.parseBuildXml(path);
        if (StringUtils.isNotBlank((String)projectName)) {
            return projectName;
        }
        if (path.contains("/")) {
            return StringUtils.substringAfterLast((String)path, (String)"/");
        }
        return path;
    }

    private String parseBuildXml(String path) {
        try {
            String fileName = StringUtils.isBlank((String)path) ? "build.xml" : path + "/build.xml";
            InputStream pom = this.factory.create(fileName);
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(ModuleDetector.class.getClassLoader());
            digester.push((Object)new StringBuffer());
            String xPath = "project";
            digester.addCallMethod(xPath, "append", 1);
            digester.addCallParam(xPath, 0, "name");
            StringBuffer result = (StringBuffer)digester.parse(pom);
            return result.toString();
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }

    private String parsePom(String fileName) {
        try {
            if (fileName.contains(TARGET)) {
                String module = StringUtils.substringBeforeLast((String)fileName, (String)TARGET);
                InputStream pom = this.factory.create(module + "/pom.xml");
                Digester digester = new Digester();
                digester.setValidating(false);
                digester.setClassLoader(ModuleDetector.class.getClassLoader());
                digester.push((Object)new StringBuffer());
                digester.addCallMethod("project/name", "append", 0);
                StringBuffer result = (StringBuffer)digester.parse(pom);
                return result.toString();
            }
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }
}

