/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.ResultSummary;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.AnnotationsBuildResult;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsResult
extends AnnotationsBuildResult {
    public WarningsResult(AbstractBuild<?, ?> build, ParserResult result) {
        super(build, result);
    }

    public WarningsResult(AbstractBuild<?, ?> build, ParserResult result, WarningsResult previous) {
        super(build, result, (AnnotationsBuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((WarningsResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((WarningsResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            return message + "<li>" + Messages.Warnings_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
        }
        return message;
    }

    protected String getSerializationFileName() {
        return "compiler-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.Warnings_ProjectAction_Name();
    }

    public JavaProject getPreviousResult() {
        WarningsResultAction action = (WarningsResultAction)this.getOwner().getAction(WarningsResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((WarningsResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((WarningsResultAction)this.getOwner().getAction(WarningsResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("warning", Warning.class);
    }
}

