/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.AnnotationParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.HpiCompileParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MavenParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    private final List<AnnotationParser> parsers = new ArrayList<AnnotationParser>();

    public ParserRegistry() {
        this.parsers.add(new HpiCompileParser());
        this.parsers.add(new JavacParser());
        this.parsers.add(new AntJavacParser());
        this.parsers.add(new MsBuildParser());
        this.parsers.add(new MavenParser());
    }

    public Collection<FileAnnotation> parse(File file) throws IOException {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (AnnotationParser parser : this.parsers) {
            annotations.addAll(parser.parse(this.createInputStream(file)));
        }
        return annotations;
    }

    protected InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

