/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.warnings.util.AbortException;
import hudson.plugins.warnings.util.HealthDescriptor;
import hudson.plugins.warnings.util.Messages;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.TrendReportHeightValidator;
import hudson.plugins.warnings.util.model.DefaultAnnotationContainer;
import hudson.plugins.warnings.util.model.FileAnnotation;
import hudson.plugins.warnings.util.model.Priority;
import hudson.plugins.warnings.util.model.WorkspaceFile;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwareMavenReporter
extends MavenReporter
implements HealthDescriptor {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = 3003791883748835331L;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;
    private String defaultEncoding;

    public HealthAwareMavenReporter(String threshold, String healthy, String unHealthy, String height, String thresholdLimit, String pluginName) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.pluginName = "[" + pluginName + "] ";
        this.validateThreshold(threshold);
        this.validateHealthiness(healthy, unHealthy);
        if (StringUtils.isBlank((String)thresholdLimit)) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
    }

    private void validateHealthiness(String healthyParameter, String unHealthyParameter) {
        if (!StringUtils.isEmpty((String)healthyParameter) && !StringUtils.isEmpty((String)unHealthyParameter)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthyParameter);
                this.unHealthyAnnotations = Integer.valueOf(unHealthyParameter);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void validateThreshold(String thresholdParameter) {
        if (!StringUtils.isEmpty((String)thresholdParameter)) {
            try {
                this.minimumAnnotations = Integer.valueOf(thresholdParameter);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        PrintStream logger = listener.getLogger();
        if (this.hasResultAction(build).booleanValue()) {
            this.log(logger, "Scipping maven reporter: there is already a result available.");
            return true;
        }
        try {
            this.defaultEncoding = pom.getProperties().getProperty("project.build.sourceEncoding");
            ParserResult result = this.perform(build, pom, mojo, logger);
            if (this.defaultEncoding == null) {
                this.log(logger, Messages.Reporter_Error_NoEncoding((Object)Charset.defaultCharset().displayName()));
                result.addErrorMessage(pom.getName(), Messages.Reporter_Error_NoEncoding((Object)Charset.defaultCharset().displayName()));
            }
            build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
            if (build.getRootDir().isRemote()) {
                this.copyFilesToMaster(logger, build.getProjectRootDir(), build.getRootDir(), result.getAnnotations());
            }
            this.evaluateBuildResult(build, logger, result);
        }
        catch (AbortException exception) {
            logger.println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    private void copyFilesToMaster(PrintStream logger, FilePath slaveRoot, FilePath masterRoot, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        FilePath directory = new FilePath(masterRoot, "workspace-files");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            FilePath masterFile = new FilePath(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                new FilePath((VirtualChannel)((Channel)null), file.getName()).copyTo(masterFile);
            }
            catch (IOException exception) {
                String message = "Can't copy file from slave to master: slave=" + file.getName() + ", master=" + masterFile.getName();
                this.log(logger, message);
                exception.printStackTrace(logger);
            }
        }
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PrintStream var4) throws InterruptedException, IOException;

    protected abstract void persistResult(ParserResult var1, MavenBuild var2);

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private void evaluateBuildResult(MavenBuildProxy build, PrintStream logger, ParserResult result) {
        int annotationCount = 0;
        for (Priority priority : Priority.collectPrioritiesFrom((Priority)this.getMinimumPriority())) {
            int numberOfAnnotations = result.getNumberOfAnnotations(priority);
            this.log(logger, "A total of " + numberOfAnnotations + " annotations have been found for priority " + priority);
            annotationCount += numberOfAnnotations;
        }
        if (annotationCount > 0 && this.isThresholdEnabled() && annotationCount >= this.getMinimumAnnotations()) {
            build.setResult(Result.UNSTABLE);
        }
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath(new FilePath(pom.getBasedir()), "target");
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return TrendReportHeightValidator.defaultHeight((String)this.height);
    }

    public Priority getMinimumPriority() {
        return Priority.valueOf((String)StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

