/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.parser.WarningsParser;
import hudson.plugins.warnings.util.JavaPackageDetector;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegexpParser
implements WarningsParser {
    protected static final String DEPRECATION = "Deprecation";
    protected static final String PROPRIETARY_API = "Proprietary API";
    private final Pattern pattern;
    private String name;

    public RegexpParser(String warningPattern, String name) {
        this(warningPattern, false, name);
    }

    public RegexpParser(String warningPattern, boolean useMultiLine, String name) {
        this.name = name;
        this.pattern = useMultiLine ? Pattern.compile(warningPattern, 8) : Pattern.compile(warningPattern);
    }

    protected void findAnnotations(String content, List<FileAnnotation> warnings) {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            Warning warning = this.createWarning(matcher);
            if (!warning.hasPackageName()) {
                String packageName = new JavaPackageDetector().detectPackageName(warning.getFileName());
                warning.setPackageName(packageName);
            }
            warnings.add((FileAnnotation)warning);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract Warning createWarning(Matcher var1);

    protected final int getLineNumber(String lineNumber) {
        if (StringUtils.isNotBlank((String)lineNumber)) {
            try {
                return Integer.parseInt(lineNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected String classifyWarning(String message) {
        if (StringUtils.contains((String)message, (String)"proprietary")) {
            return PROPRIETARY_API;
        }
        if (StringUtils.contains((String)message, (String)"deprecated")) {
            return DEPRECATION;
        }
        return "";
    }

    protected String classifyIfEmpty(String group, String message) {
        String category = StringUtils.capitalize((String)group);
        if (StringUtils.isEmpty((String)category)) {
            category = this.classifyWarning(message);
        }
        return category;
    }
}

