/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.ResultSummary;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.BuildResult;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.ResultAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class WarningsResult
extends BuildResult {
    private static final long serialVersionUID = -137460587767210579L;

    public WarningsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public WarningsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, WarningsResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((WarningsResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((WarningsResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.Warnings_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = WarningsResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.Warnings_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.Warnings_ResultAction_MultipleHighScore((Object)days) + "</li>";
        }
        long days = WarningsResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.Warnings_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.Warnings_ResultAction_MultipleNoHighScore((Object)days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "compiler-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.Warnings_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return WarningsResultAction.class;
    }

    static {
        XSTREAM.alias("warning", Warning.class);
    }
}

