/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.model.Priority;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class MsBuildParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "MSBuild";
    private static final String MS_BUILD_WARNING_PATTERN = "^(?:(.*)\\((\\d*).*\\)|.*LINK)\\s*:\\s*([Nn]ote|[Ii]nfo|[Ww]arning|(?:fatal\\s*)?[Ee]rror)\\s*([^:]*):\\s*(.*)$";

    public MsBuildParser() {
        super(MS_BUILD_WARNING_PATTERN, WARNING_TYPE);
    }

    protected Warning createWarning(Matcher matcher) {
        Priority priority = this.isOfType(matcher, "note") || this.isOfType(matcher, "info") ? Priority.LOW : (this.isOfType(matcher, "warning") ? Priority.NORMAL : Priority.HIGH);
        String fileName = matcher.group(1);
        if (StringUtils.isBlank((String)fileName)) {
            fileName = StringUtils.substringBetween((String)matcher.group(5), (String)"'");
        }
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "unknown.file";
        }
        return new Warning(fileName, this.getLineNumber(matcher.group(2)), this.getName(), matcher.group(4), matcher.group(5), priority);
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((String)matcher.group(3), (String)type);
    }
}

