/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.util.AnnotationParser;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWarningsParser
implements AnnotationParser {
    private static final long serialVersionUID = -262047528431480332L;
    private final String includePattern;
    private final String excludePattern;
    @SuppressWarnings(value={"Se"})
    private final Set<String> parserNames;
    private final String defaultEncoding;

    public FileWarningsParser(Set<String> parserNames, String defaultEncoding, String includePattern, String excludePattern) {
        this.parserNames = parserNames;
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            Collection<FileAnnotation> annotations = new ParserRegistry(ParserRegistry.getParsers(this.parserNames), this.defaultEncoding, this.includePattern, this.excludePattern).parse(file);
            for (FileAnnotation annotation : annotations) {
                annotation.setModuleName(moduleName);
            }
            return annotations;
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception, "Can't scan file for warnings: " + file.getAbsolutePath());
        }
    }
}

