/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsResult;

public final class ResultSummary {
    public static String createSummary(WarningsResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfAnnotations();
        summary.append(Messages.Warnings_ProjectAction_Name());
        summary.append(": ");
        if (bugs > 0) {
            summary.append("<a href=\"warningsResult\">");
        }
        if (bugs == 1) {
            summary.append(Messages.Warnings_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Warnings_ResultAction_MultipleWarnings(bugs));
        }
        if (bugs > 0) {
            summary.append("</a>");
        }
        summary.append(".");
        return summary.toString();
    }

    public static String createDeltaMessage(WarningsResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"warningsResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Warnings_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Warnings_ResultAction_MultipleNewWarnings(result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"warningsResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Warnings_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Warnings_ResultAction_MultipleFixedWarnings(result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

