/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.warnings.util.AreaRenderer;
import hudson.plugins.warnings.util.BuildResult;
import hudson.plugins.warnings.util.CategoryBuildResultGraph;
import hudson.plugins.warnings.util.CategoryUrlBuilder;
import hudson.plugins.warnings.util.Messages;
import hudson.plugins.warnings.util.ToolTipBuilder;
import hudson.plugins.warnings.util.ToolTipProvider;
import hudson.plugins.warnings.util.model.Priority;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityGraph
extends CategoryBuildResultGraph {
    @Override
    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        series.add(current.getNumberOfAnnotations(Priority.LOW));
        series.add(current.getNumberOfAnnotations(Priority.NORMAL));
        series.add(current.getNumberOfAnnotations(Priority.HIGH));
        return series;
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createAreaChart(dataSet);
    }

    @Override
    protected Color[] getColors() {
        return new Color[]{ColorPalette.BLUE, ColorPalette.YELLOW, ColorPalette.RED};
    }

    @Override
    @SuppressWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(String pluginName, ToolTipProvider toolTipProvider) {
        CategoryUrlBuilder url = new CategoryUrlBuilder(this.getRootUrl(), pluginName){

            protected String getDetailUrl(int row) {
                if (row == 0) {
                    return Priority.LOW.name();
                }
                if (row == 1) {
                    return Priority.NORMAL.name();
                }
                return Priority.HIGH.name();
            }
        };
        ToolTipBuilder toolTip = new ToolTipBuilder(toolTipProvider){

            protected String getShortDescription(int row) {
                if (row == 0) {
                    return Messages.Trend_PriorityLow();
                }
                if (row == 1) {
                    return Messages.Trend_PriorityNormal();
                }
                return Messages.Trend_PriorityHigh();
            }
        };
        return new AreaRenderer(url, toolTip);
    }
}

