/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.parser.YuiCompressorParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YuiCompressorParser
extends RegexpDocumentParser {
    static final String WARNING_TYPE = "YUI Compressor";
    private static final String YUI_COMPRESSOR_WARNING_PATTERN = "\\[WARNING\\] ([^:]+):line ([^:]+):column ([^:]+):(.*)\\r?\\n^(.*)$";
    private static final Pattern unusedSymbolePattern = Pattern.compile("The symbol [^ ]+ is declared but is apparently never used.*");
    private static final Pattern unusedVariablePattern = Pattern.compile("The variable [^ ]+ has already been declared in the same scope.*");

    public YuiCompressorParser() {
        super(YUI_COMPRESSOR_WARNING_PATTERN, true, WARNING_TYPE);
    }

    protected Warning createWarning(Matcher matcher) {
        String messageHeader = matcher.group(4);
        CategoryAndPriority categoryAndPriority = this.getCategoryAndPriority(messageHeader);
        String messageDetails = matcher.group(5);
        String message = messageHeader + " [" + messageDetails + "]";
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, categoryAndPriority.getCategory(), message, categoryAndPriority.getPriority());
    }

    private CategoryAndPriority getCategoryAndPriority(String message) {
        if (message.startsWith("Found an undeclared symbol")) {
            return CategoryAndPriority.UNDECLARED_SYMBOL;
        }
        if (message.startsWith("Try to use a single 'var' statement per scope")) {
            return CategoryAndPriority.USE_SINGLE_VAR;
        }
        if (unusedSymbolePattern.matcher(message).matches()) {
            return CategoryAndPriority.UNUSED_SYMBOL;
        }
        if (unusedVariablePattern.matcher(message).matches()) {
            return CategoryAndPriority.DUPLICATE_VAR;
        }
        return CategoryAndPriority.UNKNOWN;
    }
}

