/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.model.Priority;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class GccParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "gcc";
    private static final String GCC_WARNING_PATTERN = "^(.*\\.[chpimxsola0-9]+):(?:(\\d*):(?:\\d*:)*\\s*(?:(warning|error)\\s*:|\\s*(.*))|\\s*(undefined reference to.*))(.*)$";

    public GccParser() {
        super(GCC_WARNING_PATTERN, "GNU compiler (gcc)");
    }

    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        if ("warning".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.NORMAL;
        } else if ("error".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.HIGH;
        } else {
            if (StringUtils.isNotBlank((String)matcher.group(4))) {
                if (matcher.group(4).contains("instantiated from here")) {
                    return FALSE_POSITIVE;
                }
                Priority priority2 = Priority.HIGH;
                String category = "GCC error";
                return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(4), priority2);
            }
            if (matcher.group(1).contains("                 from")) {
                return FALSE_POSITIVE;
            }
            Priority priority3 = Priority.HIGH;
            String category = "GCC error";
            return new Warning(matcher.group(1), 0, WARNING_TYPE, category, matcher.group(5), priority3);
        }
        String category = "GCC " + matcher.group(3);
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(6), priority);
    }
}

