/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.warnings.util.model.AnnotationContainer;
import hudson.plugins.warnings.util.model.AnnotationProvider;
import hudson.plugins.warnings.util.model.AnnotationStream;
import hudson.plugins.warnings.util.model.FileAnnotation;
import hudson.plugins.warnings.util.model.Priority;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = 1110545450292087475L;
    protected static final XStream XSTREAM = new AnnotationStream();
    private final AbstractBuild<?, ?> owner;
    private Set<String> modules;
    private final int numberOfModules;
    private final String defaultEncoding;
    @SuppressWarnings(value={"Se"})
    private List<String> errors;

    public BuildResult(AbstractBuild<?, ?> build, Set<String> modules, Collection<String> errorMessages, String defaultEncoding) {
        this.owner = build;
        this.numberOfModules = modules.size();
        this.modules = new HashSet<String>(modules);
        this.defaultEncoding = defaultEncoding;
        this.errors = new ArrayList<String>(errorMessages);
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected Object readResolve() {
        if (this.modules == null) {
            this.modules = new HashSet<String>();
        }
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        return this;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected final XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), this.getSerializationFileName()));
    }

    protected abstract String getSerializationFileName();

    public final boolean isCurrent() {
        return ((AbstractBuild)this.getOwner().getProject().getLastBuild()).number == this.getOwner().number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public final boolean hasAnnotations() {
        return this.getContainer().hasAnnotations();
    }

    @Override
    public boolean hasNoAnnotations() {
        return this.getContainer().hasNoAnnotations();
    }

    @Override
    public boolean hasNoAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public boolean hasNoAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations() {
        return this.getContainer().getAnnotations();
    }

    @Override
    public FileAnnotation getAnnotation(long key) {
        return this.getContainer().getAnnotation(key);
    }

    @Override
    public FileAnnotation getAnnotation(String key) {
        return this.getContainer().getAnnotation(key);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(Priority priority) {
        return this.getContainer().getAnnotations(priority);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getContainer().getAnnotations(priority);
    }

    @Override
    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString(priority));
    }

    public abstract AnnotationContainer getContainer();
}

