/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.warnings.AnnotationsClassifier;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsProjectAction;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.WarningsResultBuilder;
import hudson.plugins.warnings.parser.FileWarningsParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.util.BuildResult;
import hudson.plugins.warnings.util.FilesParser;
import hudson.plugins.warnings.util.HealthAwarePublisher;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.PluginLogger;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5936973521277401764L;
    public static final WarningsDescriptor WARNINGS_DESCRIPTOR = new WarningsDescriptor();
    private final String pattern;
    private final String excludePattern;
    @SuppressWarnings(value={"Se"})
    private Set<String> parserNames = new HashSet<String>();

    @DataBoundConstructor
    public WarningsPublisher(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String height, String thresholdLimit, String pattern, String excludePattern, String defaultEncoding) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, height, thresholdLimit, defaultEncoding, "WARNINGS");
        this.pattern = pattern;
        this.excludePattern = StringUtils.stripToNull((String)excludePattern);
    }

    public Set<String> getParserNames() {
        return this.parserNames;
    }

    public void setParserNames(Set<String> parserNames) {
        this.parserNames = parserNames;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.parserNames == null) {
            this.parserNames = new HashSet<String>();
        }
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new WarningsProjectAction(project, this.getTrendHeight());
    }

    @Override
    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        ParserResult project;
        logger.log("Parsing warnings in log file...");
        File logFile = build.getLogFile();
        if (StringUtils.isNotBlank((String)this.getPattern())) {
            FilesParser parser = new FilesParser(logger, this.getPattern(), new FileWarningsParser(this.parserNames, this.getDefaultEncoding(), this.getExcludePattern()), this.isMavenBuild(build), this.isAntBuild(build));
            project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
        } else {
            project = new ParserResult(build.getProject().getWorkspace());
        }
        project.addAnnotations(new ParserRegistry(ParserRegistry.getParsers(this.parserNames), this.getDefaultEncoding(), this.getExcludePattern()).parse(logFile));
        project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new AnnotationsClassifier(project, this.getDefaultEncoding()));
        WarningsResult result = new WarningsResultBuilder().build(build, project, this.getDefaultEncoding());
        build.getActions().add(new WarningsResultAction(build, this, result));
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return WARNINGS_DESCRIPTOR;
    }
}

