/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.FilePath;
import hudson.plugins.warnings.util.ContextHashCode;
import hudson.plugins.warnings.util.ModuleDetector;
import hudson.plugins.warnings.util.ParserResult;
import hudson.plugins.warnings.util.model.FileAnnotation;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsClassifier
implements FilePath.FileCallable<ParserResult> {
    private static final long serialVersionUID = 5152042155205600031L;
    private final ParserResult result;
    private final String defaultEncoding;

    public AnnotationsClassifier(ParserResult result, String defaultEncoding) {
        this.result = result;
        this.defaultEncoding = defaultEncoding;
    }

    public ParserResult invoke(File workspace, VirtualChannel channel) throws IOException {
        ModuleDetector detector = new ModuleDetector(workspace);
        ContextHashCode contextHashCode = new ContextHashCode();
        for (FileAnnotation annotation : this.result.getAnnotations()) {
            try {
                annotation.setModuleName(detector.guessModuleName(annotation.getFileName()));
                annotation.setContextHashCode(contextHashCode.create(annotation.getFileName(), annotation.getPrimaryLineNumber(), this.defaultEncoding));
            }
            catch (IOException exception) {}
        }
        return this.result;
    }
}

