/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsPublisher;
import hudson.plugins.warnings.util.PluginDescriptor;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WarningsDescriptor
extends PluginDescriptor {
    private static final String PLUGIN_NAME = "warnings";
    private static final String ACTION_ICON = "/plugin/warnings/icons/warnings-24x24.png";

    WarningsDescriptor() {
        super(WarningsPublisher.class);
    }

    public String getDisplayName() {
        return Messages.Warnings_Publisher_Name();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getIconUrl() {
        return ACTION_ICON;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public WarningsPublisher newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
        Set parsers = this.extractParsers(formData);
        WarningsPublisher publisher = (WarningsPublisher)request.bindJSON(WarningsPublisher.class, formData);
        publisher.setParserNames(parsers);
        return publisher;
    }

    private Set<String> extractParsers(JSONObject formData) {
        HashSet<String> parsers = new HashSet<String>();
        Object values = formData.get("parsers");
        if (values instanceof JSONArray) {
            JSONArray array = (JSONArray)values;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject element = array.getJSONObject(i);
                parsers.add(element.getString("parserName"));
            }
            formData.remove("parsers");
        } else if (values instanceof JSONObject) {
            JSONObject object = (JSONObject)values;
            parsers.add(object.getString("parserName"));
            formData.remove("parsers");
        }
        return parsers;
    }
}

