/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.util.AnnotationParser;
import hudson.plugins.warnings.util.model.FileAnnotation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWarningsParser
implements AnnotationParser {
    private static final long serialVersionUID = -262047528431480332L;
    private final String excludePattern;
    @SuppressWarnings(value={"Se"})
    private final Set<String> parserNames;
    private final String defaultEncoding;

    public FileWarningsParser(Set<String> parserNames, String excludePattern, String defaultEncoding) {
        this.parserNames = parserNames;
        this.excludePattern = excludePattern;
        this.defaultEncoding = defaultEncoding;
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            Collection annotations = new ParserRegistry(ParserRegistry.getParsers((Set)this.parserNames), this.defaultEncoding, this.excludePattern).parse(file);
            for (FileAnnotation annotation : annotations) {
                annotation.setModuleName(moduleName);
            }
            return annotations;
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception, "Can't scan file for warnings: " + file.getAbsolutePath());
        }
    }
}

