/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.plugins.warnings.util.BuildResult;
import hudson.plugins.warnings.util.BuildResultGraph;
import hudson.plugins.warnings.util.DifferenceGraph;
import hudson.plugins.warnings.util.GraphConfiguration;
import hudson.plugins.warnings.util.Pair;
import hudson.plugins.warnings.util.ResultAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGraph
extends BuildResultGraph {
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, String pluginName) {
        ArrayList fixedWarnings = new ArrayList();
        ArrayList newWarnings = new ArrayList();
        this.extractPoints(configuration, resultAction, fixedWarnings, newWarnings);
        XYSeriesCollection xySeriesCollection = this.computeDifferenceSeries(fixedWarnings, newWarnings);
        JFreeChart chart = this.createXYChart((XYDataset)xySeriesCollection);
        chart.getXYPlot().getRenderer().setURLGenerator((XYURLGenerator)new XyUrlBuilder(this.getRootUrl(), pluginName));
        NumberAxis axis = new NumberAxis();
        axis.setVerticalTickLabels(true);
        axis.setNumberFormatOverride((NumberFormat)new HudsonBuildFormat(null));
        axis.setAutoRange(true);
        axis.setAutoRangeIncludesZero(false);
        axis.setLowerMargin(0.0);
        axis.setUpperMargin(0.0);
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        return chart;
    }

    private XYSeriesCollection computeDifferenceSeries(ArrayList<Pair<Integer, Integer>> fixedWarnings, ArrayList<Pair<Integer, Integer>> newWarnings) {
        XYSeries fixedSeries = new XYSeries((Comparable)((Object)"fixed"));
        XYSeries newSeries = new XYSeries((Comparable)((Object)"new"));
        int fixedCount = 0;
        int newCount = 0;
        for (int i = 0; i < fixedWarnings.size(); ++i) {
            Pair<Integer, Integer> point = fixedWarnings.get(i);
            int build = (Integer)point.getHead();
            fixedCount += ((Integer)point.getTail()).intValue();
            point = newWarnings.get(i);
            fixedSeries.add((double)build, (double)fixedCount);
            newSeries.add((double)build, (double)(newCount += ((Integer)point.getTail()).intValue()));
        }
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        xySeriesCollection.addSeries(fixedSeries);
        xySeriesCollection.addSeries(newSeries);
        return xySeriesCollection;
    }

    private void extractPoints(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, ArrayList<Pair<Integer, Integer>> fixedWarnings, ArrayList<Pair<Integer, Integer>> newWarnings) {
        Calendar oldBuildTime;
        ResultAction action = resultAction;
        int buildCount = 0;
        Calendar buildTime = action.getBuild().getTimestamp();
        do {
            BuildResult current = action.getResult();
            int build = action.getBuild().getNumber();
            fixedWarnings.add((Pair<Integer, Integer>)new Pair((Object)build, (Object)current.getNumberOfFixedWarnings()));
            newWarnings.add((Pair<Integer, Integer>)new Pair((Object)build, (Object)current.getNumberOfNewWarnings()));
            if (!action.hasPreviousResultAction()) break;
            action = action.getPreviousResultAction();
        } while ((!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount()) && (!configuration.isDayCountDefined() || this.computeDayDelta(buildTime, oldBuildTime = action.getBuild().getTimestamp()) < (long)configuration.getDayCount()));
        Collections.reverse(fixedWarnings);
        Collections.reverse(newWarnings);
    }
}

