/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.AntEclipseParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.BuckminsterParser;
import hudson.plugins.warnings.parser.ErlcParser;
import hudson.plugins.warnings.parser.GccParser;
import hudson.plugins.warnings.parser.GnatParser;
import hudson.plugins.warnings.parser.IarParser;
import hudson.plugins.warnings.parser.IntelCParser;
import hudson.plugins.warnings.parser.InvalidsParser;
import hudson.plugins.warnings.parser.JavaDocParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.parser.SunCParser;
import hudson.plugins.warnings.parser.TiCcsParser;
import hudson.plugins.warnings.parser.WarningsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    private static final List<WarningsParser> ALL_PARSERS = ParserRegistry.getAllParsers();
    private static final List<String> ALL_PARSER_NAMES = ParserRegistry.getAllParserNames();
    private final List<WarningsParser> parsers;
    private final FileFilter fileFilter;
    private final Charset defaultCharset;

    private static List<WarningsParser> getAllParsers() {
        ArrayList<Object> parsers = new ArrayList<Object>();
        parsers.add(new JavacParser());
        parsers.add(new AntJavacParser());
        parsers.add(new JavaDocParser());
        parsers.add(new AntEclipseParser());
        parsers.add(new MsBuildParser());
        parsers.add(new GccParser());
        parsers.add(new InvalidsParser());
        parsers.add(new SunCParser());
        parsers.add(new GnatParser());
        parsers.add(new ErlcParser());
        parsers.add(new IntelCParser());
        parsers.add(new IarParser());
        MsBuildParser pclintParser = new MsBuildParser();
        pclintParser.setName("PC-Lint");
        parsers.add(pclintParser);
        parsers.add(new BuckminsterParser());
        parsers.add(new TiCcsParser());
        return Collections.unmodifiableList(parsers);
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding) {
        this(parsers, defaultEncoding, "", "");
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding, String includePattern, String excludePattern) {
        this.defaultCharset = EncodingValidator.defaultCharset((String)defaultEncoding);
        this.parsers = new ArrayList<WarningsParser>(parsers);
        if (this.parsers.isEmpty()) {
            this.parsers.addAll(ALL_PARSERS);
        }
        this.fileFilter = !StringUtils.isEmpty((String)includePattern) || !StringUtils.isEmpty((String)excludePattern) ? new FileFilter(includePattern, excludePattern) : null;
    }

    protected Iterable<WarningsParser> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    public Collection<FileAnnotation> parse(File file) throws IOException {
        ArrayList allAnnotations = new ArrayList();
        for (WarningsParser parser : this.parsers) {
            allAnnotations.addAll(parser.parse(this.createReader(file)));
        }
        return this.applyExcludeFilter(allAnnotations);
    }

    public Collection<FileAnnotation> parse(InputStream file) throws IOException {
        ArrayList allAnnotations = new ArrayList();
        for (WarningsParser parser : this.parsers) {
            allAnnotations.addAll(parser.parse(this.createReader(file)));
        }
        return this.applyExcludeFilter(allAnnotations);
    }

    private Collection<FileAnnotation> applyExcludeFilter(List<FileAnnotation> allAnnotations) {
        if (this.fileFilter == null) {
            return allAnnotations;
        }
        return this.filterAnnotations(allAnnotations);
    }

    private Collection<FileAnnotation> filterAnnotations(List<FileAnnotation> annotations) {
        ArrayList<FileAnnotation> filteredAnnotations = new ArrayList<FileAnnotation>();
        for (FileAnnotation annotation : annotations) {
            if (!this.fileFilter.matches(annotation.getFileName())) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    protected Reader createReader(File file) throws FileNotFoundException {
        return this.createReader((InputStream)new FileInputStream(file));
    }

    protected Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.defaultCharset);
    }

    private static List<String> getAllParserNames() {
        HashSet<String> parsers = new HashSet<String>();
        for (WarningsParser parser : ALL_PARSERS) {
            parsers.add(parser.getName());
        }
        ArrayList sortedParsers = new ArrayList(parsers);
        Collections.sort(sortedParsers);
        return Collections.unmodifiableList(sortedParsers);
    }

    public static List<String> getAvailableParsers() {
        return ALL_PARSER_NAMES;
    }

    public static List<WarningsParser> getParsers(Set<String> parserNames) {
        ArrayList<WarningsParser> actualParsers = new ArrayList<WarningsParser>();
        for (String name : parserNames) {
            for (WarningsParser warningsParser : ALL_PARSERS) {
                if (!warningsParser.getName().equals(name)) continue;
                actualParsers.add(warningsParser);
            }
        }
        return actualParsers;
    }
}

