/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class GccParser
extends RegexpLineParser {
    static final String GCC_ERROR = "GCC error";
    static final String LINKER_ERROR = "Linker error";
    static final String WARNING_TYPE = "gcc";
    private static final String GCC_WARNING_PATTERN = "^\\s*(?:\\[.*\\]\\s*)?(.*\\.[chpimxsola0-9]+):(?:(\\d*):(?:\\d*:)*\\s*(?:(warning|error|note)\\s*:|\\s*(.*))|\\s*(undefined reference to.*))(.*)|.*ld:\\s*(.*-l(.*))$";

    public GccParser() {
        super(GCC_WARNING_PATTERN, "GNU compiler (gcc)");
    }

    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        if (StringUtils.isNotBlank((String)matcher.group(7))) {
            return new Warning(matcher.group(8), 0, WARNING_TYPE, LINKER_ERROR, matcher.group(7), Priority.HIGH);
        }
        String fileName = matcher.group(1);
        if (StringUtils.contains((String)fileName, (String)"cleartool")) {
            return FALSE_POSITIVE;
        }
        if ("warning".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.NORMAL;
        } else if ("error".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.HIGH;
        } else if ("note".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.LOW;
        } else {
            if (StringUtils.isNotBlank((String)matcher.group(4))) {
                if (matcher.group(4).contains("instantiated from here")) {
                    return FALSE_POSITIVE;
                }
                Priority priority2 = Priority.HIGH;
                String category = GCC_ERROR;
                return new Warning(fileName, this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(4), priority2);
            }
            Priority priority3 = Priority.HIGH;
            String category = GCC_ERROR;
            return new Warning(fileName, 0, WARNING_TYPE, category, matcher.group(5), priority3);
        }
        String category = "GCC " + matcher.group(3);
        return new Warning(fileName, this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(6), priority);
    }
}

