/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import groovy.lang.GroovyShell;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroovyParser {
    private final String name;
    private final String regexp;
    private final String script;

    @DataBoundConstructor
    public GroovyParser(String name, String regexp, String script) {
        this.name = name;
        this.regexp = regexp;
        this.script = script;
    }

    public boolean isValid() {
        return GroovyParser.doCheckScript((String)this.script).kind == FormValidation.Kind.OK && GroovyParser.doCheckRegexp((String)this.regexp).kind == FormValidation.Kind.OK && GroovyParser.doCheckName((String)this.regexp).kind == FormValidation.Kind.OK;
    }

    public String getName() {
        return this.name;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getScript() {
        return this.script;
    }

    public static FormValidation doCheckName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Name_isEmpty());
        }
        return FormValidation.ok();
    }

    public static FormValidation doCheckRegexp(String regexp) {
        try {
            if (StringUtils.isBlank((String)regexp)) {
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Regexp_isEmpty());
            }
            Pattern.compile(regexp);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException exception) {
            return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Regexp_invalid((Object)exception.getLocalizedMessage()));
        }
    }

    public static FormValidation doCheckScript(String script) {
        try {
            if (StringUtils.isBlank((String)script)) {
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Script_isEmpty());
            }
            GroovyShell groovyShell = new GroovyShell(WarningsDescriptor.class.getClassLoader());
            groovyShell.parse(script);
            return FormValidation.ok();
        }
        catch (CompilationFailedException exception) {
            return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Script_invalid((Object)exception.getLocalizedMessage()));
        }
    }
}

