/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.Hudson;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.GroovyParser;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.parser.AcuCobolParser;
import hudson.plugins.warnings.parser.AntEclipseParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.BuckminsterParser;
import hudson.plugins.warnings.parser.CoolfluxChessccParser;
import hudson.plugins.warnings.parser.DoxygenParser;
import hudson.plugins.warnings.parser.DynamicParser;
import hudson.plugins.warnings.parser.ErlcParser;
import hudson.plugins.warnings.parser.FlexSDKParser;
import hudson.plugins.warnings.parser.Gcc4CompilerParser;
import hudson.plugins.warnings.parser.Gcc4LinkerParser;
import hudson.plugins.warnings.parser.GccParser;
import hudson.plugins.warnings.parser.GnatParser;
import hudson.plugins.warnings.parser.IarParser;
import hudson.plugins.warnings.parser.IntelCParser;
import hudson.plugins.warnings.parser.InvalidsParser;
import hudson.plugins.warnings.parser.JavaDocParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.P4Parser;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.parser.PhpParser;
import hudson.plugins.warnings.parser.RobocopyParser;
import hudson.plugins.warnings.parser.SunCParser;
import hudson.plugins.warnings.parser.TiCcsParser;
import hudson.plugins.warnings.parser.TnsdlParser;
import hudson.plugins.warnings.parser.WarningsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ParserRegistry {
    private final List<WarningsParser> parsers;
    private final FileFilter fileFilter;
    private final Charset defaultCharset;

    public static List<String> getAvailableParsers() {
        ArrayList sortedParsers = new ArrayList(ParserRegistry.getAllParserNames());
        Collections.sort(sortedParsers);
        return Collections.unmodifiableList(sortedParsers);
    }

    private static Set<String> getAllParserNames() {
        HashSet<String> parsers = new HashSet<String>();
        for (WarningsParser parser : ParserRegistry.getAllParsers()) {
            parsers.add(parser.getName());
        }
        return parsers;
    }

    public static List<WarningsParser> getParsers(Set<String> parserNames) {
        ArrayList<WarningsParser> actualParsers = new ArrayList<WarningsParser>();
        for (String name : parserNames) {
            for (WarningsParser warningsParser : ParserRegistry.getAllParsers()) {
                if (!warningsParser.getName().equals(name)) continue;
                actualParsers.add(warningsParser);
            }
        }
        return actualParsers;
    }

    public static List<String> filterExistingParserNames(Set<String> parserNames) {
        ArrayList validNames = Lists.newArrayList();
        Set allParsers = ParserRegistry.getAllParserNames();
        for (String name : parserNames) {
            if (!allParsers.contains(name)) continue;
            validNames.add(name);
        }
        Collections.sort(validNames);
        return validNames;
    }

    private static List<WarningsParser> getAllParsers() {
        ArrayList<Object> parsers = new ArrayList<Object>();
        parsers.add(new JavacParser());
        parsers.add(new AntJavacParser());
        parsers.add(new JavaDocParser());
        parsers.add(new AntEclipseParser());
        parsers.add(new MsBuildParser());
        parsers.add(new GccParser());
        parsers.add(new Gcc4CompilerParser());
        parsers.add(new Gcc4LinkerParser());
        parsers.add(new InvalidsParser());
        parsers.add(new SunCParser());
        parsers.add(new GnatParser());
        parsers.add(new ErlcParser());
        parsers.add(new IntelCParser());
        parsers.add(new IarParser());
        MsBuildParser pclintParser = new MsBuildParser();
        pclintParser.setName("PC-Lint");
        parsers.add(pclintParser);
        parsers.add(new BuckminsterParser());
        parsers.add(new TiCcsParser());
        parsers.add(new AcuCobolParser());
        parsers.add(new FlexSDKParser());
        parsers.add(new PhpParser());
        parsers.add(new CoolfluxChessccParser());
        parsers.add(new P4Parser());
        parsers.add(new RobocopyParser());
        parsers.add(new DoxygenParser());
        parsers.add(new TnsdlParser());
        Iterable parserDescriptions = ParserRegistry.getDynamicParserDescriptions();
        parsers.addAll(ParserRegistry.getDynamicParsers((Iterable)parserDescriptions));
        return ImmutableList.copyOf(parsers);
    }

    private static Iterable<GroovyParser> getDynamicParserDescriptions() {
        WarningsDescriptor descriptor;
        Hudson instance = Hudson.getInstance();
        if (instance != null && (descriptor = (WarningsDescriptor)instance.getDescriptorByType(WarningsDescriptor.class)) != null) {
            return descriptor.getParsers();
        }
        return Collections.emptyList();
    }

    private static List<WarningsParser> getDynamicParsers(Iterable<GroovyParser> parserDescriptions) {
        ArrayList<WarningsParser> parsers = new ArrayList<WarningsParser>();
        for (GroovyParser description : parserDescriptions) {
            if (!description.isValid()) continue;
            parsers.add((WarningsParser)new DynamicParser(description.getName(), description.getRegexp(), description.getScript()));
        }
        return parsers;
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding) {
        this(parsers, defaultEncoding, "", "");
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding, String includePattern, String excludePattern) {
        this.defaultCharset = EncodingValidator.defaultCharset((String)defaultEncoding);
        this.parsers = new ArrayList<WarningsParser>(parsers);
        if (this.parsers.isEmpty()) {
            this.parsers.addAll(ParserRegistry.getAllParsers());
        }
        this.fileFilter = StringUtils.isEmpty((String)includePattern) && StringUtils.isEmpty((String)excludePattern) ? null : new FileFilter(includePattern, excludePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(File file) throws IOException {
        ArrayList allAnnotations = new ArrayList();
        for (WarningsParser parser : this.parsers) {
            Reader input = null;
            try {
                input = this.createReader(file);
                allAnnotations.addAll(parser.parse(input));
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
            }
        }
        return this.applyExcludeFilter(allAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(InputStream file) throws IOException {
        try {
            ArrayList allAnnotations = new ArrayList();
            for (WarningsParser parser : this.parsers) {
                allAnnotations.addAll(parser.parse(this.createReader(file)));
            }
            Collection collection = this.applyExcludeFilter(allAnnotations);
            return collection;
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    private Collection<FileAnnotation> applyExcludeFilter(List<FileAnnotation> allAnnotations) {
        if (this.fileFilter == null) {
            return allAnnotations;
        }
        return this.filterAnnotations(allAnnotations);
    }

    private Collection<FileAnnotation> filterAnnotations(List<FileAnnotation> annotations) {
        ArrayList<FileAnnotation> filteredAnnotations = new ArrayList<FileAnnotation>();
        for (FileAnnotation annotation : annotations) {
            if (!this.fileFilter.matches(annotation.getFileName())) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    @SuppressWarnings(value={"OBL"})
    protected Reader createReader(File file) throws FileNotFoundException {
        return this.createReader((InputStream)new FileInputStream(file));
    }

    protected Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.defaultCharset);
    }
}

