/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class TnsdlParser
extends RegexpLineParser {
    static final String WARNING_CATEGORY = "Tnsdl Error";
    static final String WARNING_TYPE = "TNSDL Translator";
    private static final String TNSDL_WARNING_PATTERN = "^tnsdl((.*)?):\\(.*\\) (.*) \\((.*)\\):(.*)$";

    public TnsdlParser() {
        super(TNSDL_WARNING_PATTERN, WARNING_TYPE, true);
    }

    protected boolean isLineInteresting(String line) {
        return line.contains("tnsdl");
    }

    protected Warning createWarning(Matcher matcher) {
        String fileName = matcher.group(3);
        int lineNumber = this.getLineNumber(matcher.group(4));
        String message = matcher.group(5);
        Priority priority = matcher.group().contains("(E)") ? Priority.HIGH : Priority.NORMAL;
        return new Warning(fileName, lineNumber, WARNING_TYPE, WARNING_CATEGORY, message, priority);
    }
}

