/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.AnnotationsClassifier;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.ModuleDetector;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsProjectAction;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.FileWarningsParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5936973521277401764L;
    private final String pattern;
    private final String includePattern;
    private final String excludePattern;
    @SuppressWarnings(value={"Se"})
    private Set<String> parserNames = new HashSet();
    private final boolean ignoreConsole;

    @DataBoundConstructor
    public WarningsPublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean canScanConsole, String pattern, String includePattern, String excludePattern) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, "WARNINGS");
        this.pattern = pattern;
        this.ignoreConsole = !canScanConsole;
        this.includePattern = StringUtils.stripToNull((String)includePattern);
        this.excludePattern = StringUtils.stripToNull((String)excludePattern);
    }

    public List<String> getParserNames() {
        return ParserRegistry.filterExistingParserNames((Set)this.parserNames);
    }

    public boolean getCanScanConsole() {
        return !this.ignoreConsole;
    }

    public void setParserNames(Set<String> parserNames) {
        this.parserNames = parserNames;
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.parserNames == null) {
            this.parserNames = new HashSet();
        }
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new WarningsProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        ParserResult project;
        File logFile = build.getLogFile();
        HashSet validParsers = Sets.newHashSet((Iterable)this.getParserNames());
        if (StringUtils.isNotBlank((String)this.getPattern())) {
            logger.log("Parsing warnings in files: " + this.getPattern());
            FilesParser parser = new FilesParser(logger, this.getPattern(), (AnnotationParser)new FileWarningsParser((Set)validParsers, this.getDefaultEncoding(), this.getIncludePattern(), this.getExcludePattern()), this.isMavenBuild(build), this.isAntBuild(build));
            project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)parser);
        } else {
            project = new ParserResult(build.getWorkspace());
        }
        if (!this.ignoreConsole || StringUtils.isBlank((String)this.getPattern())) {
            logger.log("Parsing warnings in console log...");
            ParserRegistry registry = new ParserRegistry(ParserRegistry.getParsers((Set)validParsers), this.getDefaultEncoding(), this.getIncludePattern(), this.getExcludePattern());
            Collection warnings = registry.parse(logFile, logger);
            if (!build.getWorkspace().isRemote()) {
                String workspace = build.getWorkspace().getRemote();
                ModuleDetector detector = new ModuleDetector(new File(workspace));
                for (FileAnnotation annotation : warnings) {
                    String module = detector.guessModuleName(annotation.getFileName());
                    annotation.setModuleName(module);
                }
            }
            project.addAnnotations(warnings);
        }
        project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)new AnnotationsClassifier(project, this.getDefaultEncoding()));
        for (FileAnnotation annotation : project.getAnnotations()) {
            annotation.setPathName(build.getWorkspace().getRemote());
        }
        WarningsResult result = new WarningsResult(build, this.getDefaultEncoding(), project);
        build.getActions().add(new WarningsResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public WarningsDescriptor getDescriptor() {
        return (WarningsDescriptor)super.getDescriptor();
    }
}

