/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class GnatParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "gnat";
    private static final String GNAT_WARNING_PATTERN = "^(.+.(?:ads|adb)):(\\d+):(\\d+): ((?:error:)|(?:warning:)|(?:\\(style\\))) (.+)$";

    public GnatParser() {
        super(GNAT_WARNING_PATTERN, "Ada Compiler (gnat)");
    }

    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        if ("warning:".equalsIgnoreCase(matcher.group(4))) {
            priority = Priority.NORMAL;
            category = "GNAT warning";
        } else if ("(style)".equalsIgnoreCase(matcher.group(4))) {
            priority = Priority.LOW;
            category = "GNAT style";
        } else {
            priority = Priority.HIGH;
            category = "GNAT error";
        }
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(5), priority);
    }
}

