// CHECKSTYLE:OFF

package hudson.plugins.warnings;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Compiler Warnings Trend
     * 
     */
    public static String Warnings_Trend_Name() {
        return holder.format("Warnings.Trend.Name");
    }

    /**
     * Compiler Warnings Trend
     * 
     */
    public static Localizable _Warnings_Trend_Name() {
        return new Localizable(holder, "Warnings.Trend.Name");
    }

    /**
     *  1 fixed warning
     * 
     */
    public static String Warnings_ResultAction_OneFixedWarning() {
        return holder.format("Warnings.ResultAction.OneFixedWarning");
    }

    /**
     *  1 fixed warning
     * 
     */
    public static Localizable _Warnings_ResultAction_OneFixedWarning() {
        return new Localizable(holder, "Warnings.ResultAction.OneFixedWarning");
    }

    /**
     * Scan for compiler warnings
     * 
     */
    public static String Warnings_Publisher_Name() {
        return holder.format("Warnings.Publisher.Name");
    }

    /**
     * Scan for compiler warnings
     * 
     */
    public static Localizable _Warnings_Publisher_Name() {
        return new Localizable(holder, "Warnings.Publisher.Name");
    }

    /**
     * Compiler Warnings: no warnings found.
     * 
     */
    public static String Warnings_ResultAction_HealthReportNoItem() {
        return holder.format("Warnings.ResultAction.HealthReportNoItem");
    }

    /**
     * Compiler Warnings: no warnings found.
     * 
     */
    public static Localizable _Warnings_ResultAction_HealthReportNoItem() {
        return new Localizable(holder, "Warnings.ResultAction.HealthReportNoItem");
    }

    /**
     * {0} new warnings
     * 
     */
    public static String Warnings_ResultAction_MultipleNewWarnings(Object arg1) {
        return holder.format("Warnings.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     * {0} new warnings
     * 
     */
    public static Localizable _Warnings_ResultAction_MultipleNewWarnings(Object arg1) {
        return new Localizable(holder, "Warnings.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     * New Compiler Warnings Warnings
     * 
     */
    public static String Warnings_NewWarnings_Detail_header() {
        return holder.format("Warnings.NewWarnings.Detail.header");
    }

    /**
     * New Compiler Warnings Warnings
     * 
     */
    public static Localizable _Warnings_NewWarnings_Detail_header() {
        return new Localizable(holder, "Warnings.NewWarnings.Detail.header");
    }

    /**
     *  1 warning
     * 
     */
    public static String Warnings_ResultAction_OneWarning() {
        return holder.format("Warnings.ResultAction.OneWarning");
    }

    /**
     *  1 warning
     * 
     */
    public static Localizable _Warnings_ResultAction_OneWarning() {
        return new Localizable(holder, "Warnings.ResultAction.OneWarning");
    }

    /**
     * Fixed Compiler Warnings Warnings
     * 
     */
    public static String Warnings_FixedWarnings_Detail_header() {
        return holder.format("Warnings.FixedWarnings.Detail.header");
    }

    /**
     * Fixed Compiler Warnings Warnings
     * 
     */
    public static Localizable _Warnings_FixedWarnings_Detail_header() {
        return new Localizable(holder, "Warnings.FixedWarnings.Detail.header");
    }

    /**
     * Compiler Warnings: {0} warnings found.
     * 
     */
    public static String Warnings_ResultAction_HealthReportMultipleItem(Object arg1) {
        return holder.format("Warnings.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * Compiler Warnings: {0} warnings found.
     * 
     */
    public static Localizable _Warnings_ResultAction_HealthReportMultipleItem(Object arg1) {
        return new Localizable(holder, "Warnings.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * {0} warnings
     * 
     */
    public static String Warnings_ResultAction_MultipleWarnings(Object arg1) {
        return holder.format("Warnings.ResultAction.MultipleWarnings", arg1);
    }

    /**
     * {0} warnings
     * 
     */
    public static Localizable _Warnings_ResultAction_MultipleWarnings(Object arg1) {
        return new Localizable(holder, "Warnings.ResultAction.MultipleWarnings", arg1);
    }

    /**
     * Compiler Warnings
     * 
     */
    public static String Warnings_ProjectAction_Name() {
        return holder.format("Warnings.ProjectAction.Name");
    }

    /**
     * Compiler Warnings
     * 
     */
    public static Localizable _Warnings_ProjectAction_Name() {
        return new Localizable(holder, "Warnings.ProjectAction.Name");
    }

    /**
     *  1 new warning
     * 
     */
    public static String Warnings_ResultAction_OneNewWarning() {
        return holder.format("Warnings.ResultAction.OneNewWarning");
    }

    /**
     *  1 new warning
     * 
     */
    public static Localizable _Warnings_ResultAction_OneNewWarning() {
        return new Localizable(holder, "Warnings.ResultAction.OneNewWarning");
    }

    /**
     * {0} fixed warnings
     * 
     */
    public static String Warnings_ResultAction_MultipleFixedWarnings(Object arg1) {
        return holder.format("Warnings.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * {0} fixed warnings
     * 
     */
    public static Localizable _Warnings_ResultAction_MultipleFixedWarnings(Object arg1) {
        return new Localizable(holder, "Warnings.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * Compiler Warnings: 1 warning found.
     * 
     */
    public static String Warnings_ResultAction_HealthReportSingleItem() {
        return holder.format("Warnings.ResultAction.HealthReportSingleItem");
    }

    /**
     * Compiler Warnings: 1 warning found.
     * 
     */
    public static Localizable _Warnings_ResultAction_HealthReportSingleItem() {
        return new Localizable(holder, "Warnings.ResultAction.HealthReportSingleItem");
    }

}
