/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class Gcc4LinkerParser
extends RegexpLineParser {
    static final String WARNING_CATEGORY = "GCC4 Linker Error";
    static final String WARNING_TYPE = "gcc4 linker";
    private static final String LINKER_WARNING_PATTERN = "^(.+?)(?:(?::(?:(\\d+):)? (undefined reference to .*))|(?::?\\(\\.\\w+\\+0x[0-9a-fA-F]+\\)): (?:(warning): )?(.*))|.*/ld(?:\\.exe)?: (?:(warning): )?(.*)$";

    public Gcc4LinkerParser() {
        super(LINKER_WARNING_PATTERN, "GNU compiler 4 (ld)");
    }

    protected Warning createWarning(Matcher matcher) {
        String message;
        String fileName = StringUtils.defaultString((String)matcher.group(1));
        int lineNumber = this.getLineNumber(matcher.group(2));
        Priority priority = Priority.LOW;
        if (StringUtils.isNotBlank((String)matcher.group(7))) {
            priority = StringUtils.equalsIgnoreCase((String)matcher.group(6), (String)"warning") ? Priority.NORMAL : Priority.HIGH;
            message = matcher.group(7);
        } else if (StringUtils.isNotBlank((String)matcher.group(3))) {
            message = matcher.group(3);
            priority = Priority.HIGH;
        } else {
            priority = StringUtils.equalsIgnoreCase((String)matcher.group(4), (String)"warning") ? Priority.NORMAL : Priority.HIGH;
            message = matcher.group(5);
        }
        return new Warning(fileName, lineNumber, WARNING_TYPE, WARNING_CATEGORY, message, priority);
    }
}

