/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class ErlcParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "erlc";
    private static final String ERLC_WARNING_PATTERN = "^(.+\\.(?:erl|yrl|mib|bin|rel|asn1|idl)):(\\d*): ([wW]arning: )?(.+)$";

    public ErlcParser() {
        super(ERLC_WARNING_PATTERN, "Erlang Compiler");
    }

    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        String filename = matcher.group(1);
        int linenumber = this.getLineNumber(matcher.group(2));
        String message = matcher.group(4);
        String categoryMatch = matcher.group(3);
        if ("warning: ".equalsIgnoreCase(categoryMatch)) {
            priority = Priority.NORMAL;
            category = "ERLC " + categoryMatch.substring(0, categoryMatch.length() - 2);
        } else {
            priority = Priority.HIGH;
            category = "ERLC Error";
        }
        return new Warning(filename, linenumber, WARNING_TYPE, category, message, priority);
    }
}

