/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class IarParser
extends RegexpDocumentParser {
    static final String WARNING_TYPE = "IAR";
    private static final String IAR_WARNING_PATTERN = "(?s)(?i)\\s*\\^[\\r]??\\n\"(.+?\\.[chpsola0-9]+)\",(\\d+)\\s*(Remark|Warning|Error)\\s*\\[(Pe\\d+)\\]\\s*:\\s*(.+?)([\\r]??\\n){2}?";

    public IarParser() {
        super(IAR_WARNING_PATTERN, true, "IAR compiler (C/C++)");
    }

    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        String message = matcher.group(5).replaceAll("\\s+", " ");
        if ("remark".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.LOW;
        } else if ("warning".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.NORMAL;
        } else if ("error".equalsIgnoreCase(matcher.group(3))) {
            priority = Priority.HIGH;
        } else {
            Priority priority2 = Priority.HIGH;
            String category = "IAR Error";
            return new Warning(matcher.group(1), 0, WARNING_TYPE, category, message, priority2);
        }
        String category = matcher.group(4);
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, message, priority);
    }
}

