/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class PhpParser
extends RegexpLineParser {
    static final String FATAL_ERROR_CATEGORY = "PHP Fatal error";
    static final String WARNING_CATEGORY = "PHP Warning";
    static final String NOTICE_CATEGORY = "PHP Notice";
    static final String WARNING_TYPE = "PHP Runtime Warning";
    private static final String PHP_WARNING_PATTERN = "^.*(PHP Warning|PHP Notice|PHP Fatal error):\\s+(.+ in (.+) on line (\\d+))$";

    public PhpParser() {
        super(PHP_WARNING_PATTERN, WARNING_TYPE, true);
    }

    protected boolean isLineInteresting(String line) {
        return line.contains("PHP");
    }

    protected Warning createWarning(Matcher matcher) {
        String category = matcher.group(1);
        String message = matcher.group(2);
        String fileName = matcher.group(3);
        String start = matcher.group(4);
        Priority priority = Priority.NORMAL;
        if (FATAL_ERROR_CATEGORY.equals(category)) {
            priority = Priority.HIGH;
        }
        return new Warning(fileName, Integer.parseInt(start), WARNING_TYPE, category, message, priority);
    }
}

