/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class DoxygenParser
extends RegexpDocumentParser {
    static final String WARNING_CATEGORY = "Doxygen warning";
    static final String WARNING_TYPE = "doxygen";
    private static final String DOXYGEN_WARNING_PATTERN = "^(?:(?:((?:/|[A-Za-z]:).+?):(-?\\d+): (Warning|Error)|<.+>:-?\\d+(?:: (Warning|Error))?): (.+(?:\\n[^/<\\n][^:\\n][^/\\n].+)*)|(Notice|Warning|Error): (.+))$";
    private static final int FILE_NAME_GROUP = 1;
    private static final int FILE_LINE_GROUP = 2;
    private static final int FILE_TYPE_GROUP = 3;
    private static final int FUNC_TYPE_GROUP = 4;
    private static final int LOCAL_MESSAGE_GROUP = 5;
    private static final int GLOBAL_TYPE_GROUP = 6;
    private static final int GLOBAL_MESSAGE_GROUP = 7;

    public DoxygenParser() {
        super(DOXYGEN_WARNING_PATTERN, true, "Doxygen");
    }

    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        String message;
        String fileName = "";
        int lineNumber = 0;
        if (StringUtils.isNotBlank((String)matcher.group(5))) {
            message = matcher.group(5);
            if (StringUtils.isNotBlank((String)matcher.group(1))) {
                fileName = matcher.group(1);
                lineNumber = this.getLineNumber(matcher.group(2));
                priority = this.parsePriority(matcher.group(3));
            } else {
                priority = this.parsePriority(matcher.group(4));
            }
        } else if (StringUtils.isNotBlank((String)matcher.group(7))) {
            message = matcher.group(7);
            priority = this.parsePriority(matcher.group(6));
        } else {
            message = "Unknown doxygen error.";
            priority = Priority.HIGH;
        }
        return new Warning(fileName, lineNumber, WARNING_TYPE, WARNING_CATEGORY, message, priority);
    }

    @SuppressWarnings(value={"DB"})
    private Priority parsePriority(String warningTypeString) {
        Priority priority = StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"notice") ? Priority.LOW : (StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"warning") ? Priority.NORMAL : (StringUtils.equalsIgnoreCase((String)warningTypeString, (String)"error") ? Priority.HIGH : Priority.HIGH));
        return priority;
    }
}

