/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.AcuCobolParser;
import hudson.plugins.warnings.parser.AntEclipseParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.BuckminsterParser;
import hudson.plugins.warnings.parser.CoolfluxChessccParser;
import hudson.plugins.warnings.parser.DoxygenParser;
import hudson.plugins.warnings.parser.ErlcParser;
import hudson.plugins.warnings.parser.FlexSDKParser;
import hudson.plugins.warnings.parser.Gcc4CompilerParser;
import hudson.plugins.warnings.parser.Gcc4LinkerParser;
import hudson.plugins.warnings.parser.GccParser;
import hudson.plugins.warnings.parser.GnatParser;
import hudson.plugins.warnings.parser.IarParser;
import hudson.plugins.warnings.parser.IntelCParser;
import hudson.plugins.warnings.parser.InvalidsParser;
import hudson.plugins.warnings.parser.JavaDocParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.P4Parser;
import hudson.plugins.warnings.parser.PhpParser;
import hudson.plugins.warnings.parser.RegexpParser;
import hudson.plugins.warnings.parser.RobocopyParser;
import hudson.plugins.warnings.parser.SunCParser;
import hudson.plugins.warnings.parser.TiCcsParser;
import hudson.plugins.warnings.parser.WarningsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    private static final List<WarningsParser> ALL_PARSERS = ParserRegistry.getAllParsers();
    private static final List<String> ALL_PARSER_NAMES = ParserRegistry.getAllParserNames();
    private final List<WarningsParser> parsers;
    private final FileFilter fileFilter;
    private final Charset defaultCharset;

    private static List<WarningsParser> getAllParsers() {
        ArrayList<RegexpParser> parsers = new ArrayList<RegexpParser>();
        parsers.add(new JavacParser());
        parsers.add(new AntJavacParser());
        parsers.add(new JavaDocParser());
        parsers.add(new AntEclipseParser());
        parsers.add(new MsBuildParser());
        parsers.add(new GccParser());
        parsers.add(new Gcc4CompilerParser());
        parsers.add(new Gcc4LinkerParser());
        parsers.add(new InvalidsParser());
        parsers.add(new SunCParser());
        parsers.add(new GnatParser());
        parsers.add(new ErlcParser());
        parsers.add(new IntelCParser());
        parsers.add(new IarParser());
        MsBuildParser pclintParser = new MsBuildParser();
        pclintParser.setName("PC-Lint");
        parsers.add(pclintParser);
        parsers.add(new BuckminsterParser());
        parsers.add(new TiCcsParser());
        parsers.add(new AcuCobolParser());
        parsers.add(new FlexSDKParser());
        parsers.add(new PhpParser());
        parsers.add(new CoolfluxChessccParser());
        parsers.add(new P4Parser());
        parsers.add(new RobocopyParser());
        parsers.add(new DoxygenParser());
        return ImmutableList.copyOf(parsers);
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding) {
        this(parsers, defaultEncoding, "", "");
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding, String includePattern, String excludePattern) {
        this.defaultCharset = EncodingValidator.defaultCharset((String)defaultEncoding);
        this.parsers = new ArrayList<WarningsParser>(parsers);
        if (this.parsers.isEmpty()) {
            this.parsers.addAll(ALL_PARSERS);
        }
        this.fileFilter = StringUtils.isEmpty((String)includePattern) && StringUtils.isEmpty((String)excludePattern) ? null : new FileFilter(includePattern, excludePattern);
    }

    protected Iterable<WarningsParser> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(File file) throws IOException {
        ArrayList<FileAnnotation> allAnnotations = new ArrayList<FileAnnotation>();
        for (WarningsParser parser : this.parsers) {
            Reader input = null;
            try {
                input = this.createReader(file);
                allAnnotations.addAll(parser.parse(input));
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
            }
        }
        return this.applyExcludeFilter(allAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(InputStream file) throws IOException {
        try {
            ArrayList<FileAnnotation> allAnnotations = new ArrayList<FileAnnotation>();
            for (WarningsParser parser : this.parsers) {
                allAnnotations.addAll(parser.parse(this.createReader(file)));
            }
            Collection<FileAnnotation> collection = this.applyExcludeFilter(allAnnotations);
            return collection;
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    private Collection<FileAnnotation> applyExcludeFilter(List<FileAnnotation> allAnnotations) {
        if (this.fileFilter == null) {
            return allAnnotations;
        }
        return this.filterAnnotations(allAnnotations);
    }

    private Collection<FileAnnotation> filterAnnotations(List<FileAnnotation> annotations) {
        ArrayList<FileAnnotation> filteredAnnotations = new ArrayList<FileAnnotation>();
        for (FileAnnotation annotation : annotations) {
            if (!this.fileFilter.matches(annotation.getFileName())) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    @SuppressWarnings(value={"OBL"})
    protected Reader createReader(File file) throws FileNotFoundException {
        return this.createReader(new FileInputStream(file));
    }

    protected Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.defaultCharset);
    }

    private static List<String> getAllParserNames() {
        HashSet<String> parsers = new HashSet<String>();
        for (WarningsParser parser : ALL_PARSERS) {
            parsers.add(parser.getName());
        }
        ArrayList sortedParsers = new ArrayList(parsers);
        Collections.sort(sortedParsers);
        return Collections.unmodifiableList(sortedParsers);
    }

    public static List<String> getAvailableParsers() {
        return ALL_PARSER_NAMES;
    }

    public static List<WarningsParser> getParsers(Set<String> parserNames) {
        ArrayList<WarningsParser> actualParsers = new ArrayList<WarningsParser>();
        for (String name : parserNames) {
            for (WarningsParser warningsParser : ALL_PARSERS) {
                if (!warningsParser.getName().equals(name)) continue;
                actualParsers.add(warningsParser);
            }
        }
        return actualParsers;
    }

    private static final class FileFilter
    extends DirectoryScanner {
        private static final String SEPARATOR = ",\\s*";

        public FileFilter(String includePattern, String excludePattern) {
            if (StringUtils.isEmpty((String)includePattern)) {
                this.setIncludes(new String[]{"**/*"});
            } else {
                this.setIncludes(includePattern.split(SEPARATOR));
            }
            if (StringUtils.isEmpty((String)excludePattern)) {
                this.setExcludes(new String[0]);
            } else {
                this.setExcludes(excludePattern.split(SEPARATOR));
            }
        }

        public boolean matches(String name) {
            String canonicalName = File.separatorChar == '\\' ? StringUtils.replaceChars((String)name, (char)'/', (char)'\\') : name;
            return this.isIncluded(canonicalName) && !this.isExcluded(canonicalName);
        }
    }
}

