/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class JavacParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "Java Compiler";
    private static final String JAVAC_WARNING_PATTERN = "^\\[WARNING\\]\\s*(.*):\\[(\\d*)[.,; 0-9]*\\]\\s*(?:\\[(\\w*)\\])?\\s*(.*)$";

    public JavacParser() {
        super(JAVAC_WARNING_PATTERN, WARNING_TYPE, true);
    }

    protected boolean isLineInteresting(String line) {
        return line.contains("[WARNING]");
    }

    protected Warning createWarning(Matcher matcher) {
        String message = matcher.group(4);
        String category = this.classifyIfEmpty(matcher.group(3), message);
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, message);
    }
}

