/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.warnings.GroovyParser;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsPublisher;
import hudson.plugins.warnings.parser.Warning;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=100.0)
public final class WarningsDescriptor
extends PluginDescriptor {
    private static final String PLUGIN_NAME = "warnings";
    private static final String ACTION_ICON = "/plugin/warnings/icons/warnings-24x24.png";
    private static final int MAX_MESSAGE_LENGTH = 60;
    private final CopyOnWriteList<GroovyParser> groovyParsers = new CopyOnWriteList();

    public WarningsDescriptor() {
        super(WarningsPublisher.class);
    }

    public String getDisplayName() {
        return Messages.Warnings_Publisher_Name();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getIconUrl() {
        return ACTION_ICON;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public WarningsPublisher newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
        Set<String> parsers = this.extractParsers(formData);
        WarningsPublisher publisher = (WarningsPublisher)((Object)request.bindJSON(WarningsPublisher.class, formData));
        publisher.setParserNames(parsers);
        return publisher;
    }

    private Set<String> extractParsers(JSONObject formData) {
        HashSet<String> parsers = new HashSet<String>();
        Object values = formData.get("parsers");
        if (values instanceof JSONArray) {
            JSONArray array = (JSONArray)values;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject element = array.getJSONObject(i);
                parsers.add(element.getString("parserName"));
            }
            formData.remove("parsers");
        } else if (values instanceof JSONObject) {
            JSONObject object = (JSONObject)values;
            parsers.add(object.getString("parserName"));
            formData.remove("parsers");
        }
        return parsers;
    }

    public CopyOnWriteList<GroovyParser> getParsers() {
        return this.groovyParsers;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.groovyParsers.replaceBy((Collection)req.bindJSONToList(GroovyParser.class, formData.get("parsers")));
        return true;
    }

    public FormValidation doCheckName(@QueryParameter(required=true) String name) {
        return GroovyParser.doCheckName(name);
    }

    public FormValidation doCheckRegexp(@QueryParameter(required=true) String regexp) {
        return GroovyParser.doCheckRegexp(regexp);
    }

    public FormValidation doCheckScript(@QueryParameter(required=true) String script) {
        return GroovyParser.doCheckScript(script);
    }

    public FormValidation doCheckExample(@QueryParameter String example, @QueryParameter String regexp, @QueryParameter String script) {
        if (StringUtils.isNotBlank((String)example) && StringUtils.isNotBlank((String)regexp) && StringUtils.isNotBlank((String)script)) {
            return this.parseExample(script, example, regexp);
        }
        return FormValidation.ok();
    }

    private FormValidation parseExample(String script, String example, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(example);
        if (matcher.matches()) {
            Binding binding = new Binding();
            binding.setVariable("matcher", (Object)matcher);
            GroovyShell shell = new GroovyShell(WarningsDescriptor.class.getClassLoader(), binding);
            Object result = null;
            try {
                result = shell.evaluate(script);
            }
            catch (Exception exception) {
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_exception(exception.getMessage()));
            }
            if (result instanceof Warning) {
                StringBuilder okMessage = new StringBuilder(Messages.Warnings_GroovyParser_Error_Example_ok_title());
                Warning warning = (Warning)((Object)result);
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_file(warning.getFileName()));
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_line(warning.getPrimaryLineNumber()));
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_priority(warning.getPriority().getLongLocalizedString()));
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_category(warning.getCategory()));
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_type(warning.getType()));
                this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_message(warning.getMessage()));
                return FormValidation.ok((String)okMessage.toString());
            }
            return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_wrongReturnType(result));
        }
        return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_regexpDoesNotMatch());
    }

    private void message(StringBuilder okMessage, String message) {
        okMessage.append("\n");
        int max = 60;
        if (message.length() > max) {
            int size = max / 2 - 1;
            okMessage.append(message.substring(0, size));
            okMessage.append("[...]");
            okMessage.append(message.substring(message.length() - size, message.length()));
        } else {
            okMessage.append(message);
        }
    }
}

