/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class DynamicParser
extends RegexpLineParser {
    private final String script;
    private static final Logger LOGGER = Logger.getLogger(DynamicParser.class.getName());

    public DynamicParser(String name, String regexp, String script) {
        super(regexp, name, true);
        this.script = script;
    }

    protected Warning createWarning(Matcher matcher) {
        Binding binding = new Binding();
        binding.setVariable("matcher", (Object)matcher);
        GroovyShell shell = new GroovyShell(WarningsDescriptor.class.getClassLoader(), binding);
        Object result = null;
        try {
            result = shell.evaluate(this.script);
            if (result instanceof Warning) {
                return (Warning)((Object)result);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, this.getName() + ": exception during parsing: ", exception);
        }
        return FALSE_POSITIVE;
    }
}

