/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.RegexpParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegexpLineParser
extends RegexpParser {
    private final boolean isStringMatchActivated;

    public RegexpLineParser(String warningPattern, String name) {
        this(warningPattern, name, false);
    }

    public RegexpLineParser(String warningPattern, String name, boolean isStringMatchActivated) {
        super(warningPattern, name);
        this.isStringMatchActivated = isStringMatchActivated;
    }

    @Override
    public Collection<FileAnnotation> parse(Reader file) throws IOException {
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        LineIterator iterator = IOUtils.lineIterator((Reader)file);
        if (this.isStringMatchActivated) {
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (!this.isLineInteresting(line)) continue;
                this.findAnnotations(line, warnings);
            }
        } else {
            while (iterator.hasNext()) {
                this.findAnnotations(iterator.nextLine(), warnings);
            }
        }
        iterator.close();
        return warnings;
    }

    protected boolean isLineInteresting(String line) {
        return true;
    }
}

