/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class IntelCParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "Intel";
    private static final String INTEL_PATTERN = "^(.*)\\((\\d*)\\)?:.*((?:remark|warning|error)\\s*#*\\d*)\\s*:\\s*(.*)$";

    public IntelCParser() {
        super(INTEL_PATTERN, "Intel compiler", true);
    }

    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error") || line.contains("remark");
    }

    protected Warning createWarning(Matcher matcher) {
        String category = StringUtils.capitalize((String)matcher.group(3));
        Priority priority = StringUtils.startsWith((String)category, (String)"Remark") ? Priority.LOW : (StringUtils.startsWith((String)category, (String)"Error") ? Priority.HIGH : Priority.NORMAL);
        return new Warning(matcher.group(1), this.getLineNumber(matcher.group(2)), WARNING_TYPE, category, matcher.group(4), priority);
    }
}

