/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class TiCcsParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "TiCcs";
    private static final String TI_CCS_WARNING_PATTERN = "^((\"(.*)\",\\s*)(line\\s*(\\d+)(\\s*\\(.*\\))?:)?\\s*)?(WARNING|ERROR|remark|warning|(fatal\\s*)?error)(!\\s*at line\\s(\\d+))?\\s*([^:]*)\\s*:\\s*(.*)$";

    public TiCcsParser() {
        super(TI_CCS_WARNING_PATTERN, "Texas Instruments Code Composer Studio (C/C++)");
    }

    protected Warning createWarning(Matcher matcher) {
        String lineNumber;
        Priority priority = this.isOfType(matcher, "remark") ? Priority.LOW : (this.isOfType(matcher, "warning") ? Priority.NORMAL : Priority.HIGH);
        String fileName = matcher.group(3);
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "unknown.file";
        }
        if (StringUtils.isBlank((String)(lineNumber = matcher.group(5)))) {
            lineNumber = matcher.group(10);
        }
        return new Warning(fileName, this.getLineNumber(lineNumber), WARNING_TYPE, matcher.group(11), matcher.group(12), priority);
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((String)matcher.group(7), (String)type);
    }
}

