/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.wasbuilder;

import com.michelin.cio.hudson.plugins.wasbuilder.WASBuildStep;
import com.michelin.cio.hudson.plugins.wasbuilder.WASServer;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASInstallation
extends ToolInstallation
implements NodeSpecific<WASInstallation>,
EnvironmentSpecific<WASInstallation> {
    public static final String WSADMIN_BAT = "wsadmin.bat";
    public static final String WSADMIN_SH = "wsadmin.sh";

    @DataBoundConstructor
    public WASInstallation(String name, String home) {
        super(name, WASInstallation.removeTrailingBackslash(home), Collections.EMPTY_LIST);
    }

    public WASInstallation forEnvironment(EnvVars env) {
        return new WASInstallation(this.getName(), env.expand(this.getHome()));
    }

    public WASInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new WASInstallation(this.getName(), this.translateFor(node, log));
    }

    public static WASInstallation getWasInstallationByName(String installationName) {
        for (WASInstallation installation : (WASInstallation[])((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
            if (installationName == null || !installation.getName().equals(installationName)) continue;
            return installation;
        }
        return null;
    }

    public String getWsadminExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File wsadminFile = WASInstallation.this.getWsadminFile("bin");
                if (wsadminFile.exists()) {
                    return wsadminFile.getPath();
                }
                wsadminFile = WASInstallation.this.getWsadminFile(null);
                if (wsadminFile.exists()) {
                    return wsadminFile.getPath();
                }
                return null;
            }
        });
    }

    private File getWsadminFile(String binFolder) {
        String wsadminFileName = WSADMIN_SH;
        binFolder = !StringUtils.isEmpty((String)binFolder) ? binFolder + "/" : "";
        if (Hudson.isWindows()) {
            wsadminFileName = WSADMIN_BAT;
        }
        return new File(Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars), binFolder + wsadminFileName);
    }

    private static String removeTrailingBackslash(String s) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)s, (String)"/"), (String)"\\");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends ToolDescriptor<WASInstallation> {
        private WASServer[] servers;

        public DescriptorImpl() {
            this.setInstallations(new WASInstallation[0]);
            this.load();
        }

        public String[] getConntypes() {
            return WASServer.CONNTYPES;
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(WASBuildStep.class).format("DisplayName", new Object[0]);
        }

        public WASServer[] getServers() {
            if (this.servers != null) {
                return (WASServer[])this.servers.clone();
            }
            return null;
        }

        private void setServers(WASServer ... servers) {
            if (servers != null) {
                this.servers = (WASServer[])servers.clone();
            }
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(WASInstallation.class, formData.get("wasinstall")).toArray(new WASInstallation[0]));
            this.setServers(req.bindJSONToList(WASServer.class, formData.get("wasserver")).toArray(new WASServer[0]));
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            if (value == null || value.getPath().length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASInstallation.class).format("InstallationFolderMustBeSet", new Object[0]));
            }
            if (!value.isDirectory()) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASInstallation.class).format("NotAFolder", new Object[]{value}));
            }
            if (Hudson.isWindows()) {
                boolean noWsadminBat = false;
                boolean noWsadminThinClientBat = false;
                File wsadminFile = new File(value, "bin\\wsadmin.bat");
                if (!wsadminFile.exists()) {
                    noWsadminBat = true;
                    wsadminFile = new File(value, WASInstallation.WSADMIN_BAT);
                    if (!wsadminFile.exists()) {
                        noWsadminThinClientBat = true;
                    }
                }
                if (noWsadminThinClientBat || noWsadminThinClientBat && noWsadminBat) {
                    return FormValidation.error((String)ResourceBundleHolder.get(WASInstallation.class).format("NotAWASInstallationFolder", new Object[]{value}));
                }
            } else {
                boolean noWsadminSh = false;
                boolean noWsadminThinClientSh = false;
                File wsadminFile = new File(value, "bin/wsadmin.sh");
                if (!wsadminFile.exists()) {
                    noWsadminSh = true;
                    wsadminFile = new File(value, WASInstallation.WSADMIN_SH);
                    if (!wsadminFile.exists()) {
                        noWsadminThinClientSh = true;
                    }
                }
                if (noWsadminThinClientSh || noWsadminThinClientSh && noWsadminSh) {
                    return FormValidation.error((String)ResourceBundleHolder.get(WASInstallation.class).format("NotAWASInstallationFolder", new Object[]{value}));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("NameMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckConntype(@QueryParameter String value) {
            if (value == null) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("ConntypeMustBeSet", new Object[0]));
            }
            if (!Arrays.asList(WASServer.CONNTYPES).contains(value)) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("InvalidConntype", new Object[]{value}));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHost(@QueryParameter String value) throws IOException, ServletException {
            InetAddress inetAddress;
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("HostMustBeSet", new Object[0]));
            }
            try {
                inetAddress = InetAddress.getByName(value);
            }
            catch (UnknownHostException uhe) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("HostNotValid", new Object[]{value}));
            }
            catch (SecurityException se) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("HostSecurityException", new Object[]{value}));
            }
            try {
                if (!inetAddress.isReachable(1000)) {
                    throw new IOException();
                }
            }
            catch (IOException ioe) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("HostCantBeReached", new Object[]{value}));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            int port;
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("PortMustBeSet", new Object[0]));
            }
            try {
                port = Integer.parseInt(value);
                if (port < 0 || port > 65535) {
                    return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("PortMustBeInteger", new Object[0]));
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)ResourceBundleHolder.get(WASServer.class).format("PortMustBeInteger", new Object[0]));
            }
            if (port < 1024 || port > 49151) {
                return FormValidation.warning((String)ResourceBundleHolder.get(WASServer.class).format("PortNotPreferredValue", new Object[]{port}));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUser(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(WASServer.class).format("UserMustBeSetIfSecurityEnabled", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(WASServer.class).format("PasswordMustBeSetIfSecurityEnabled", new Object[0]));
            }
            return FormValidation.ok();
        }
    }
}

