/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.wasbuilder;

import com.michelin.cio.hudson.plugins.wasbuilder.WASInstallation;
import com.michelin.cio.hudson.plugins.wasbuilder.WASServer;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASBuildStep
extends Builder {
    public static final String LANG_JACL = "Jacl";
    public static final String LANG_JYTHON = "Jython";
    public static final String[] LANG = new String[]{"Jython", "Jacl"};
    private final String additionalClasspath;
    private final boolean appendTrace;
    private final String commands;
    private final String javaOptions;
    private final String jobId;
    private final String language;
    private Secret password;
    private final String profileScriptFiles;
    private final String propertiesFiles;
    private final String runIf;
    private final String scriptFile;
    private final String scriptParameters;
    private final String traceFile;
    private final String user;
    private final String wasServerName;

    @DataBoundConstructor
    public WASBuildStep(String additionalClasspath, boolean appendTrace, String commands, String javaOptions, String jobId, String language, String profileScriptFiles, String propertiesFiles, String runIf, String scriptFile, String scriptParameters, String traceFile, String wasServerName, String user, String password) {
        this.additionalClasspath = additionalClasspath.trim();
        this.appendTrace = appendTrace;
        this.commands = commands.trim();
        this.javaOptions = javaOptions.trim();
        this.jobId = jobId.trim();
        this.language = !language.equals(LANG_JACL) && !language.equals(LANG_JYTHON) ? LANG_JYTHON : language;
        this.profileScriptFiles = profileScriptFiles.trim();
        this.propertiesFiles = propertiesFiles.trim();
        this.runIf = runIf.trim();
        this.scriptFile = scriptFile.trim();
        this.scriptParameters = scriptParameters.trim();
        this.traceFile = traceFile.trim();
        this.wasServerName = wasServerName;
        this.user = user.trim();
        this.password = Secret.fromString((String)password);
    }

    public String getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    public boolean isAppendTrace() {
        return this.appendTrace;
    }

    public String getCommands() {
        return this.commands;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPassword() {
        return this.password != null ? this.password.toString() : null;
    }

    public String getProfileScriptFiles() {
        return this.profileScriptFiles;
    }

    public String getPropertiesFiles() {
        return this.propertiesFiles;
    }

    public String getRunIf() {
        return this.runIf;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getScriptParameters() {
        return this.scriptParameters;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public String getUser() {
        return this.user;
    }

    public WASServer getWasServer() {
        for (WASServer server : this.getDescriptor().getWasServers()) {
            if (this.getWasServerName() == null || !server.getName().equals(this.getWasServerName())) continue;
            return server;
        }
        return null;
    }

    public String getWasServerName() {
        return this.wasServerName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        WASServer wasServer;
        AbstractProject project = build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        VariableResolver varResolver = build.getBuildVariableResolver();
        if (this.getRunIf() != null && this.getRunIf().length() > 0) {
            listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("SearchingForBuildOrEnvVar", new Object[]{this.getRunIf()}));
            String runIfVar = (String)varResolver.resolve(this.getRunIf());
            if (runIfVar != null) {
                if (runIfVar.trim().length() <= 0) {
                    listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("BuildStepNotRunBecauseOfBuildVar", new Object[]{this.getRunIf()}));
                    return true;
                }
                listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("BuildStepRunBecauseOfBuildVar", new Object[]{this.getRunIf()}));
            } else {
                listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("BuildVarNotFound", new Object[]{this.getRunIf()}));
                if (!env.containsKey((Object)this.getRunIf())) {
                    listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("BuildStepNotRunBecauseOfEnvVar", new Object[]{this.getRunIf()}));
                    return true;
                }
                listener.getLogger().println(ResourceBundleHolder.get(WASBuildStep.class).format("BuildStepRunBecauseOfEnvVar", new Object[]{this.getRunIf()}));
            }
        }
        if ((wasServer = this.getWasServer()) == null) {
            listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("NoServerSet", new Object[0]));
            return false;
        }
        WASInstallation wasInstallation = wasServer.getWasInstallation();
        if (wasInstallation == null) {
            listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("NoInstallationSet", new Object[]{wasServer.getName()}));
            return false;
        }
        wasInstallation = wasInstallation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
        String wsAdminExecutable = (wasInstallation = wasInstallation.forEnvironment(env)).getWsadminExecutable(launcher);
        if (wsAdminExecutable == null) {
            listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("NoWsAdminExecutable", new Object[]{wasInstallation.getName(), wasServer.getName()}));
            return false;
        }
        args.add(wsAdminExecutable);
        args.add(new String[]{"-conntype", wasServer.getConntype()});
        args.add(new String[]{"-host", wasServer.getHost()});
        args.add(new String[]{"-port", Integer.toString(wasServer.getPort())});
        String user = null;
        String password = null;
        if (!StringUtils.isEmpty((String)this.getUser())) {
            user = Util.replaceMacro((String)env.expand(this.getUser()), (VariableResolver)varResolver);
            password = Util.replaceMacro((String)env.expand(this.getPassword()), (VariableResolver)varResolver);
            listener.getLogger().println("Using user " + user + " defined at the build step level");
        } else if (!StringUtils.isEmpty((String)wasServer.getUser())) {
            user = wasServer.getUser();
            password = wasServer.getPassword();
            listener.getLogger().println("Using user " + user + " defined at the server level");
        }
        if (!StringUtils.isEmpty(user)) {
            args.add(new String[]{"-user", wasServer.getUser()});
            if (!StringUtils.isEmpty((String)password)) {
                args.add("-password");
                args.addMasked(wasServer.getPassword());
            }
        }
        args.add(new String[]{"-lang", this.getLanguage().toLowerCase()});
        if (this.getCommands() != null && this.getCommands().length() > 0) {
            for (String command : Util.tokenize((String)Util.replaceMacro((String)env.expand(this.getCommands()), (VariableResolver)varResolver), (String)"\n\r\f")) {
                args.add(new String[]{"-c", command});
            }
        } else if (this.getScriptFile() != null && this.getScriptFile().length() > 0) {
            FilePath scriptFilePath = project.getWorkspace().child(Util.replaceMacro((String)env.expand(this.getScriptFile()), (VariableResolver)varResolver));
            if (!scriptFilePath.exists()) {
                listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("ScriptFileNotFound", new Object[]{scriptFilePath.toURI()}));
                return false;
            }
            args.add("-f");
            args.add((Object)scriptFilePath);
        } else {
            listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("NoCommandNorScriptFileSet", new Object[0]));
            return false;
        }
        if (this.getPropertiesFiles() != null && this.getPropertiesFiles().length() > 0) {
            for (String propertiesFile : Util.tokenize((String)Util.replaceMacro((String)env.expand(this.getPropertiesFiles()), (VariableResolver)varResolver))) {
                FilePath propertiesFilePath = project.getWorkspace().child(propertiesFile);
                if (propertiesFilePath.exists()) {
                    args.add("-p");
                    args.add((Object)propertiesFilePath);
                    continue;
                }
                listener.error(ResourceBundleHolder.get(WASBuildStep.class).format("PropertiesFileNotFound", new Object[0]), new Object[]{propertiesFilePath.toURI()});
            }
        }
        if (this.getProfileScriptFiles() != null && this.getProfileScriptFiles().length() > 0) {
            for (String profileScriptFile : Util.tokenize((String)Util.replaceMacro((String)env.expand(this.getProfileScriptFiles()), (VariableResolver)varResolver))) {
                FilePath profileScriptFilePath = project.getWorkspace().child(profileScriptFile);
                if (profileScriptFilePath.exists()) {
                    args.add("-profile");
                    args.add((Object)profileScriptFilePath);
                    continue;
                }
                listener.error(ResourceBundleHolder.get(WASBuildStep.class).format("ProfileScriptFileNotFound", new Object[]{profileScriptFilePath.toURI()}));
            }
        }
        if (this.getJavaOptions() != null && this.getJavaOptions().length() > 0) {
            for (String javaOption : Util.tokenize((String)Util.replaceMacro((String)env.expand(this.getJavaOptions()), (VariableResolver)varResolver))) {
                args.add(new String[]{"-javaoption", javaOption});
            }
        }
        if (this.getAdditionalClasspath() != null && this.getAdditionalClasspath().length() > 0) {
            args.add(new String[]{"-wsadmin_classpath", this.getAdditionalClasspath()});
        }
        if (this.getJobId() != null && this.getJobId().length() > 0) {
            args.add(new String[]{"-jobid", Util.replaceMacro((String)env.expand(this.getJobId()), (VariableResolver)varResolver)});
        }
        if (this.getTraceFile() != null && this.getTraceFile().length() > 0) {
            FilePath traceFilePath = project.getWorkspace().child(Util.replaceMacro((String)env.expand(this.getTraceFile()), (VariableResolver)varResolver));
            args.add("-tracefile");
            args.add((Object)traceFilePath);
        }
        if (this.isAppendTrace()) {
            args.add(new String[]{"-appendtrace", Boolean.toString(this.isAppendTrace())});
        }
        if (this.getScriptParameters() != null && this.getScriptFile().length() > 0) {
            args.addTokenized(Util.replaceMacro((String)env.expand(this.getScriptParameters()), (VariableResolver)varResolver).replaceAll("[\t\r\n]+", " "));
        }
        try {
            if (launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).join() != 0) return false;
            return true;
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            listener.fatalError(ResourceBundleHolder.get(WASBuildStep.class).format("ExecutionFailed", new Object[0]));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends WASBuildStep> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(WASBuildStep.class).format("DisplayName", new Object[0]);
        }

        public String[] getLanguages() {
            return LANG;
        }

        public WASServer[] getWasServers() {
            return ((WASInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(WASInstallation.DescriptorImpl.class)).getServers();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return this.getWasServers() != null && this.getWasServers().length > 0;
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(WASBuildStep.class, formData);
        }

        public FormValidation doCheckCommands(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(WASBuildStep.class).format("CommandsOrScriptFileMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScriptFile(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(WASBuildStep.class).format("ScriptFileOrCommandsMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }
    }
}

